/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.filter.util;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.json.JsonData;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.RelativeDateFilterStartDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.RollingDateFilterStartDto;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.DateFilterUtil;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateFilterQueryUtilES {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final Logger LOG = LoggerFactory.getLogger(DateFilterQueryUtilES.class);

    private DateFilterQueryUtilES() {
    }

    public static void addFilters(BoolQuery.Builder query, List<DateFilterDataDto<?>> dates, String dateField, ZoneId timezone) {
        if (dates != null) {
            for (DateFilterDataDto<?> dateDto : dates) {
                DateFilterQueryUtilES.createRangeQuery(dateDto, dateField, timezone).ifPresent(r -> query.filter(f -> f.range(r)));
            }
        }
    }

    public static Optional<RangeQuery> createRangeQuery(DateFilterDataDto<?> dateFilterDto, String dateField, ZoneId timezone) {
        switch (dateFilterDto.getType()) {
            case FIXED: {
                return DateFilterQueryUtilES.createFixedDateFilter((OffsetDateTime)dateFilterDto.getStart(), dateFilterDto.getEnd(), dateField, timezone);
            }
            case ROLLING: {
                return DateFilterQueryUtilES.createRollingDateFilter((RollingDateFilterStartDto)dateFilterDto.getStart(), dateField, timezone).map(RangeQuery.Builder::build);
            }
            case RELATIVE: {
                return DateFilterQueryUtilES.createRelativeDateFilter((RelativeDateFilterStartDto)dateFilterDto.getStart(), dateField, timezone).map(RangeQuery.Builder::build);
            }
        }
        LOG.warn("Cannot execute date filter. Unknown type [{}]", (Object)dateFilterDto.getType());
        return Optional.empty();
    }

    private static Optional<RangeQuery> createFixedDateFilter(OffsetDateTime start, OffsetDateTime end, String dateField, ZoneId timezone) {
        if (end == null && start == null) {
            return Optional.empty();
        }
        RangeQuery.Builder builder = new RangeQuery.Builder();
        builder.field(dateField);
        if (end != null) {
            OffsetDateTime endDateWithCorrectTimezone = end.atZoneSameInstant(timezone).toOffsetDateTime();
            builder.lte(JsonData.of((Object)FORMATTER.format(endDateWithCorrectTimezone)));
        }
        if (start != null) {
            OffsetDateTime startDateWithCorrectTimezone = start.atZoneSameInstant(timezone).toOffsetDateTime();
            builder.gte(JsonData.of((Object)FORMATTER.format(startDateWithCorrectTimezone)));
        }
        builder.format("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return Optional.of(builder.build());
    }

    private static Optional<RangeQuery.Builder> createRollingDateFilter(RollingDateFilterStartDto startDto, String dateField, ZoneId timezone) {
        if (startDto == null || startDto.getUnit() == null || startDto.getValue() == null) {
            return Optional.empty();
        }
        RangeQuery.Builder queryDate = new RangeQuery.Builder();
        queryDate.field(dateField);
        OffsetDateTime now = LocalDateUtil.getCurrentTimeWithTimezone((ZoneId)timezone);
        queryDate.lte(JsonData.of((Object)FORMATTER.format(now)));
        if (DateUnit.QUARTERS.equals((Object)startDto.getUnit())) {
            LOG.warn("Cannot create date filter: {} is not supported for rolling date filters", (Object)startDto.getUnit());
            throw new OptimizeValidationException(String.format("%s is not supported for rolling date filters", startDto.getUnit()));
        }
        OffsetDateTime dateBeforeGivenFilter = now.minus(startDto.getValue(), ChronoUnit.valueOf(startDto.getUnit().getId().toUpperCase()));
        queryDate.gte(JsonData.of((Object)FORMATTER.format(dateBeforeGivenFilter)));
        queryDate.format("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return Optional.of(queryDate);
    }

    private static Optional<RangeQuery.Builder> createRelativeDateFilter(RelativeDateFilterStartDto startDto, String dateField, ZoneId timezone) {
        if (startDto == null || startDto.getUnit() == null || startDto.getValue() == null) {
            return Optional.empty();
        }
        RangeQuery.Builder queryDate = new RangeQuery.Builder();
        queryDate.field(dateField);
        OffsetDateTime now = LocalDateUtil.getCurrentTimeWithTimezone((ZoneId)timezone);
        if (startDto.getValue() == 0L) {
            queryDate.lte(JsonData.of((Object)FORMATTER.format(now)));
            queryDate.gte(JsonData.of((Object)FORMATTER.format(DateFilterUtil.getStartOfCurrentInterval(now, startDto.getUnit()))));
        } else {
            OffsetDateTime startOfCurrentInterval = DateFilterUtil.getStartOfCurrentInterval(now, startDto.getUnit());
            OffsetDateTime startOfPreviousInterval = DateFilterUtil.getStartOfPreviousInterval(startOfCurrentInterval, startDto.getUnit(), startDto.getValue());
            queryDate.lt(JsonData.of((Object)FORMATTER.format(startOfCurrentInterval)));
            queryDate.gte(JsonData.of((Object)FORMATTER.format(startOfPreviousInterval)));
        }
        queryDate.format("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return Optional.of(queryDate);
    }
}

