/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.filter;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.FilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.AssigneeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CanceledFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CanceledFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CanceledInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CandidateGroupFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CompletedFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CompletedInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CompletedOrCanceledFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.DeletedIncidentFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.DurationFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ExecutedFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ExecutingFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FilterApplicationLevel;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeDurationFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeEndDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeStartDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.InstanceEndDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.InstanceStartDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.MultipleVariableFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.NoIncidentFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.NonCanceledInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.NonSuspendedInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.OpenIncidentFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ResolvedIncidentFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.RunningFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.RunningInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.SuspendedInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.UserTaskFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.VariableFilterDto;
import io.camunda.optimize.service.db.es.filter.AssigneeQueryFilterES;
import io.camunda.optimize.service.db.es.filter.CanceledFlowNodeQueryFilterES;
import io.camunda.optimize.service.db.es.filter.CanceledFlowNodesOnlyQueryFilterES;
import io.camunda.optimize.service.db.es.filter.CanceledInstancesOnlyQueryFilterES;
import io.camunda.optimize.service.db.es.filter.CandidateGroupQueryFilterES;
import io.camunda.optimize.service.db.es.filter.CompletedFlowNodesOnlyQueryFilterES;
import io.camunda.optimize.service.db.es.filter.CompletedInstancesOnlyQueryFilterES;
import io.camunda.optimize.service.db.es.filter.CompletedOrCanceledFlowNodesOnlyQueryFilterES;
import io.camunda.optimize.service.db.es.filter.DeletedIncidentQueryFilterES;
import io.camunda.optimize.service.db.es.filter.DurationQueryFilterES;
import io.camunda.optimize.service.db.es.filter.ExecutedFlowNodeQueryFilterES;
import io.camunda.optimize.service.db.es.filter.ExecutingFlowNodeQueryFilterES;
import io.camunda.optimize.service.db.es.filter.FlowNodeDurationQueryFilterES;
import io.camunda.optimize.service.db.es.filter.FlowNodeEndDateQueryFilterES;
import io.camunda.optimize.service.db.es.filter.FlowNodeStartDateQueryFilterES;
import io.camunda.optimize.service.db.es.filter.InstanceEndDateQueryFilterES;
import io.camunda.optimize.service.db.es.filter.InstanceStartDateQueryFilterES;
import io.camunda.optimize.service.db.es.filter.InstancesContainingUserTasksFilterES;
import io.camunda.optimize.service.db.es.filter.NoIncidentQueryFilterES;
import io.camunda.optimize.service.db.es.filter.NonCanceledInstancesOnlyQueryFilterES;
import io.camunda.optimize.service.db.es.filter.NonSuspendedInstancesOnlyQueryFilterES;
import io.camunda.optimize.service.db.es.filter.OpenIncidentQueryFilterES;
import io.camunda.optimize.service.db.es.filter.ProcessMultiVariableQueryFilterES;
import io.camunda.optimize.service.db.es.filter.ProcessVariableQueryFilterES;
import io.camunda.optimize.service.db.es.filter.QueryFilterEnhancerES;
import io.camunda.optimize.service.db.es.filter.ResolvedIncidentQueryFilterES;
import io.camunda.optimize.service.db.es.filter.RunningFlowNodesOnlyQueryFilterES;
import io.camunda.optimize.service.db.es.filter.RunningInstancesOnlyQueryFilterES;
import io.camunda.optimize.service.db.es.filter.SuspendedInstancesOnlyQueryFilterES;
import io.camunda.optimize.service.db.es.filter.util.IncidentFilterQueryUtilES;
import io.camunda.optimize.service.db.es.filter.util.ModelElementFilterQueryUtilES;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessQueryFilterEnhancerES
implements QueryFilterEnhancerES<ProcessFilterDto<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessQueryFilterEnhancerES.class);
    private final ConfigurationService configurationService;
    private final Environment environment;
    private final InstanceStartDateQueryFilterES instanceStartDateQueryFilter;
    private final InstanceEndDateQueryFilterES instanceEndDateQueryFilter;
    private final ProcessVariableQueryFilterES variableQueryFilter;
    private final ProcessMultiVariableQueryFilterES multiVariableQueryFilter;
    private final ExecutedFlowNodeQueryFilterES executedFlowNodeQueryFilter;
    private final ExecutingFlowNodeQueryFilterES executingFlowNodeQueryFilter;
    private final CanceledFlowNodeQueryFilterES canceledFlowNodeQueryFilter;
    private final DurationQueryFilterES durationQueryFilter;
    private final RunningInstancesOnlyQueryFilterES runningInstancesOnlyQueryFilter;
    private final CompletedInstancesOnlyQueryFilterES completedInstancesOnlyQueryFilter;
    private final CanceledInstancesOnlyQueryFilterES canceledInstancesOnlyQueryFilter;
    private final NonCanceledInstancesOnlyQueryFilterES nonCanceledInstancesOnlyQueryFilter;
    private final SuspendedInstancesOnlyQueryFilterES suspendedInstancesOnlyQueryFilter;
    private final NonSuspendedInstancesOnlyQueryFilterES nonSuspendedInstancesOnlyQueryFilter;
    private final FlowNodeDurationQueryFilterES flowNodeDurationQueryFilter;
    private final AssigneeQueryFilterES assigneeQueryFilter;
    private final CandidateGroupQueryFilterES candidateGroupQueryFilter;
    private final OpenIncidentQueryFilterES openIncidentQueryFilter;
    private final DeletedIncidentQueryFilterES deletedIncidentQueryFilter;
    private final ResolvedIncidentQueryFilterES resolvedIncidentQueryFilter;
    private final NoIncidentQueryFilterES noIncidentQueryFilter;
    private final RunningFlowNodesOnlyQueryFilterES runningFlowNodesOnlyQueryFilter;
    private final CompletedFlowNodesOnlyQueryFilterES completedFlowNodesOnlyQueryFilter;
    private final CanceledFlowNodesOnlyQueryFilterES canceledFlowNodesOnlyQueryFilter;
    private final CompletedOrCanceledFlowNodesOnlyQueryFilterES completedOrCanceledFlowNodesOnlyQueryFilter;
    private final InstancesContainingUserTasksFilterES instancesContainingUserTasksFilter;
    private final FlowNodeStartDateQueryFilterES flowNodeStartDateQueryFilter;
    private final FlowNodeEndDateQueryFilterES flowNodeEndDateQueryFilter;

    public ProcessQueryFilterEnhancerES(ConfigurationService configurationService, Environment environment, InstanceStartDateQueryFilterES instanceStartDateQueryFilter, InstanceEndDateQueryFilterES instanceEndDateQueryFilter, ProcessVariableQueryFilterES variableQueryFilter, ProcessMultiVariableQueryFilterES multiVariableQueryFilter, ExecutedFlowNodeQueryFilterES executedFlowNodeQueryFilter, ExecutingFlowNodeQueryFilterES executingFlowNodeQueryFilter, CanceledFlowNodeQueryFilterES canceledFlowNodeQueryFilter, DurationQueryFilterES durationQueryFilter, RunningInstancesOnlyQueryFilterES runningInstancesOnlyQueryFilter, CompletedInstancesOnlyQueryFilterES completedInstancesOnlyQueryFilter, CanceledInstancesOnlyQueryFilterES canceledInstancesOnlyQueryFilter, NonCanceledInstancesOnlyQueryFilterES nonCanceledInstancesOnlyQueryFilter, SuspendedInstancesOnlyQueryFilterES suspendedInstancesOnlyQueryFilter, NonSuspendedInstancesOnlyQueryFilterES nonSuspendedInstancesOnlyQueryFilter, FlowNodeDurationQueryFilterES flowNodeDurationQueryFilter, AssigneeQueryFilterES assigneeQueryFilter, CandidateGroupQueryFilterES candidateGroupQueryFilter, OpenIncidentQueryFilterES openIncidentQueryFilter, DeletedIncidentQueryFilterES deletedIncidentQueryFilter, ResolvedIncidentQueryFilterES resolvedIncidentQueryFilter, NoIncidentQueryFilterES noIncidentQueryFilter, RunningFlowNodesOnlyQueryFilterES runningFlowNodesOnlyQueryFilter, CompletedFlowNodesOnlyQueryFilterES completedFlowNodesOnlyQueryFilter, CanceledFlowNodesOnlyQueryFilterES canceledFlowNodesOnlyQueryFilter, CompletedOrCanceledFlowNodesOnlyQueryFilterES completedOrCanceledFlowNodesOnlyQueryFilter, InstancesContainingUserTasksFilterES instancesContainingUserTasksFilter, FlowNodeStartDateQueryFilterES flowNodeStartDateQueryFilter, FlowNodeEndDateQueryFilterES flowNodeEndDateQueryFilter) {
        this.configurationService = configurationService;
        this.environment = environment;
        this.instanceStartDateQueryFilter = instanceStartDateQueryFilter;
        this.instanceEndDateQueryFilter = instanceEndDateQueryFilter;
        this.variableQueryFilter = variableQueryFilter;
        this.multiVariableQueryFilter = multiVariableQueryFilter;
        this.executedFlowNodeQueryFilter = executedFlowNodeQueryFilter;
        this.executingFlowNodeQueryFilter = executingFlowNodeQueryFilter;
        this.canceledFlowNodeQueryFilter = canceledFlowNodeQueryFilter;
        this.durationQueryFilter = durationQueryFilter;
        this.runningInstancesOnlyQueryFilter = runningInstancesOnlyQueryFilter;
        this.completedInstancesOnlyQueryFilter = completedInstancesOnlyQueryFilter;
        this.canceledInstancesOnlyQueryFilter = canceledInstancesOnlyQueryFilter;
        this.nonCanceledInstancesOnlyQueryFilter = nonCanceledInstancesOnlyQueryFilter;
        this.suspendedInstancesOnlyQueryFilter = suspendedInstancesOnlyQueryFilter;
        this.nonSuspendedInstancesOnlyQueryFilter = nonSuspendedInstancesOnlyQueryFilter;
        this.flowNodeDurationQueryFilter = flowNodeDurationQueryFilter;
        this.assigneeQueryFilter = assigneeQueryFilter;
        this.candidateGroupQueryFilter = candidateGroupQueryFilter;
        this.openIncidentQueryFilter = openIncidentQueryFilter;
        this.deletedIncidentQueryFilter = deletedIncidentQueryFilter;
        this.resolvedIncidentQueryFilter = resolvedIncidentQueryFilter;
        this.noIncidentQueryFilter = noIncidentQueryFilter;
        this.runningFlowNodesOnlyQueryFilter = runningFlowNodesOnlyQueryFilter;
        this.completedFlowNodesOnlyQueryFilter = completedFlowNodesOnlyQueryFilter;
        this.canceledFlowNodesOnlyQueryFilter = canceledFlowNodesOnlyQueryFilter;
        this.completedOrCanceledFlowNodesOnlyQueryFilter = completedOrCanceledFlowNodesOnlyQueryFilter;
        this.instancesContainingUserTasksFilter = instancesContainingUserTasksFilter;
        this.flowNodeStartDateQueryFilter = flowNodeStartDateQueryFilter;
        this.flowNodeEndDateQueryFilter = flowNodeEndDateQueryFilter;
    }

    @Override
    public void addFilterToQuery(BoolQuery.Builder query, List<ProcessFilterDto<?>> filters, FilterContext filterContext) {
        if (!CollectionUtils.isEmpty(filters)) {
            this.instanceStartDateQueryFilter.addFilters(query, this.extractInstanceFilters(filters, InstanceStartDateFilterDto.class), filterContext);
            this.instanceEndDateQueryFilter.addFilters(query, this.extractInstanceFilters(filters, InstanceEndDateFilterDto.class), filterContext);
            this.variableQueryFilter.addFilters(query, this.extractInstanceFilters(filters, VariableFilterDto.class), filterContext);
            this.multiVariableQueryFilter.addFilters(query, this.extractInstanceFilters(filters, MultipleVariableFilterDto.class), filterContext);
            this.executedFlowNodeQueryFilter.addFilters(query, this.extractInstanceFilters(filters, ExecutedFlowNodeFilterDto.class), filterContext);
            this.executingFlowNodeQueryFilter.addFilters(query, this.extractInstanceFilters(filters, ExecutingFlowNodeFilterDto.class), filterContext);
            this.canceledFlowNodeQueryFilter.addFilters(query, this.extractInstanceFilters(filters, CanceledFlowNodeFilterDto.class), filterContext);
            this.durationQueryFilter.addFilters(query, this.extractInstanceFilters(filters, DurationFilterDto.class), filterContext);
            this.runningInstancesOnlyQueryFilter.addFilters(query, this.extractInstanceFilters(filters, RunningInstancesOnlyFilterDto.class), filterContext);
            this.completedInstancesOnlyQueryFilter.addFilters(query, this.extractInstanceFilters(filters, CompletedInstancesOnlyFilterDto.class), filterContext);
            this.canceledInstancesOnlyQueryFilter.addFilters(query, this.extractInstanceFilters(filters, CanceledInstancesOnlyFilterDto.class), filterContext);
            this.nonCanceledInstancesOnlyQueryFilter.addFilters(query, this.extractInstanceFilters(filters, NonCanceledInstancesOnlyFilterDto.class), filterContext);
            this.suspendedInstancesOnlyQueryFilter.addFilters(query, this.extractInstanceFilters(filters, SuspendedInstancesOnlyFilterDto.class), filterContext);
            this.nonSuspendedInstancesOnlyQueryFilter.addFilters(query, this.extractInstanceFilters(filters, NonSuspendedInstancesOnlyFilterDto.class), filterContext);
            this.flowNodeDurationQueryFilter.addFilters(query, this.extractInstanceFilters(filters, FlowNodeDurationFilterDto.class), filterContext);
            if (this.isAssigneeFiltersEnabled()) {
                this.assigneeQueryFilter.addFilters(query, this.extractInstanceFilters(filters, AssigneeFilterDto.class), filterContext);
            }
            this.candidateGroupQueryFilter.addFilters(query, this.extractInstanceFilters(filters, CandidateGroupFilterDto.class), filterContext);
            this.openIncidentQueryFilter.addFilters(query, this.extractInstanceFilters(filters, OpenIncidentFilterDto.class), filterContext);
            this.deletedIncidentQueryFilter.addFilters(query, this.extractInstanceFilters(filters, DeletedIncidentFilterDto.class), filterContext);
            this.resolvedIncidentQueryFilter.addFilters(query, this.extractInstanceFilters(filters, ResolvedIncidentFilterDto.class), filterContext);
            this.noIncidentQueryFilter.addFilters(query, this.extractInstanceFilters(filters, NoIncidentFilterDto.class), filterContext);
            this.runningFlowNodesOnlyQueryFilter.addFilters(query, this.extractInstanceFilters(filters, RunningFlowNodesOnlyFilterDto.class), filterContext);
            this.completedFlowNodesOnlyQueryFilter.addFilters(query, this.extractInstanceFilters(filters, CompletedFlowNodesOnlyFilterDto.class), filterContext);
            this.canceledFlowNodesOnlyQueryFilter.addFilters(query, this.extractInstanceFilters(filters, CanceledFlowNodesOnlyFilterDto.class), filterContext);
            this.completedOrCanceledFlowNodesOnlyQueryFilter.addFilters(query, this.extractInstanceFilters(filters, CompletedOrCanceledFlowNodesOnlyFilterDto.class), filterContext);
            this.instancesContainingUserTasksFilter.addFilters(query, this.extractInstanceFilters(filters, UserTaskFlowNodesOnlyFilterDto.class), filterContext);
            this.flowNodeStartDateQueryFilter.addFilters(query, this.extractInstanceFilters(filters, FlowNodeStartDateFilterDto.class), filterContext);
            this.flowNodeEndDateQueryFilter.addFilters(query, this.extractInstanceFilters(filters, FlowNodeEndDateFilterDto.class), filterContext);
        }
        this.addInstanceFilterForViewLevelMatching(query, filters, filterContext);
    }

    public <T extends FilterDataDto> List<T> extractInstanceFilters(List<ProcessFilterDto<?>> filter, Class<? extends ProcessFilterDto<T>> clazz) {
        return filter.stream().filter(clazz::isInstance).filter(f -> FilterApplicationLevel.INSTANCE.equals((Object)f.getFilterLevel())).map(dateFilter -> dateFilter.getData()).collect(Collectors.toList());
    }

    private void addInstanceFilterForViewLevelMatching(BoolQuery.Builder query, List<ProcessFilterDto<?>> filters, FilterContext filterContext) {
        ModelElementFilterQueryUtilES.addInstanceFilterForRelevantViewLevelFilters(filters, filterContext).ifPresent(n -> query.filter(f -> f.nested(n.build())));
        IncidentFilterQueryUtilES.addInstanceFilterForRelevantViewLevelFilters(filters).ifPresent(n -> query.filter(f -> f.nested(n.build())));
    }

    private boolean isAssigneeFiltersEnabled() {
        return this.configurationService.getUiConfiguration().isUserTaskAssigneeAnalyticsEnabled();
    }

    public InstanceStartDateQueryFilterES getInstanceStartDateQueryFilter() {
        return this.instanceStartDateQueryFilter;
    }

    public InstanceEndDateQueryFilterES getInstanceEndDateQueryFilter() {
        return this.instanceEndDateQueryFilter;
    }
}

