/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.filter;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.MultipleVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.VariableFilterDataDto;
import io.camunda.optimize.service.db.es.filter.AbstractProcessVariableQueryFilterES;
import io.camunda.optimize.service.db.es.filter.QueryFilterES;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessMultiVariableQueryFilterES
extends AbstractProcessVariableQueryFilterES
implements QueryFilterES<MultipleVariableFilterDataDto> {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessMultiVariableQueryFilterES.class);

    @Override
    public void addFilters(BoolQuery.Builder query, List<MultipleVariableFilterDataDto> multiVariableFilters, FilterContext filterContext) {
        if (multiVariableFilters != null) {
            query.filter(multiVariableFilters.stream().map(multiVariableFilter -> this.buildMultiVariableFilterQuery((MultipleVariableFilterDataDto)multiVariableFilter, filterContext).build()).toList());
        }
    }

    private Query.Builder buildMultiVariableFilterQuery(MultipleVariableFilterDataDto multipleVariableFilter, FilterContext filterContext) {
        Query.Builder variableFilterBuilder = new Query.Builder();
        variableFilterBuilder.bool(b -> {
            multipleVariableFilter.getData().forEach(variableFilter -> b.should(this.createFilterQueryBuilder((VariableFilterDataDto<?>)variableFilter, filterContext.getTimezone()).build(), new Query[0]));
            return b;
        });
        return variableFilterBuilder;
    }
}

