/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.filter;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.FilterOperator;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.OperatorMultipleValuesFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.BooleanVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.DateVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.OperatorMultipleValuesVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.StringVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.VariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.data.BooleanVariableFilterSubDataDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.es.filter.AbstractVariableQueryFilterES;
import io.camunda.optimize.service.db.es.filter.QueryFilterES;
import io.camunda.optimize.service.db.es.filter.util.DateFilterQueryUtilES;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.filter.util.OperatorMultipleValuesVariableFilterDataDtoUtil;
import io.camunda.optimize.service.util.DecisionVariableHelper;
import io.camunda.optimize.service.util.ValidationHelper;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DecisionVariableQueryFilterES
extends AbstractVariableQueryFilterES
implements QueryFilterES<VariableFilterDataDto<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionVariableQueryFilterES.class);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    abstract String getVariablePath();

    @Override
    public void addFilters(BoolQuery.Builder query, List<VariableFilterDataDto<?>> variableFilters, FilterContext filterContext) {
        if (variableFilters != null) {
            query.filter(variableFilters.stream().map(variable -> this.createFilterQueryBuilder((VariableFilterDataDto<?>)variable, filterContext.getTimezone()).build()).toList());
        }
    }

    private Query.Builder createFilterQueryBuilder(VariableFilterDataDto<?> dto, ZoneId timezone) {
        ValidationHelper.ensureNotNull("Variable filter data", dto.getData());
        Query.Builder queryBuilder = new Query.Builder();
        queryBuilder.matchAll(a -> a);
        switch (dto.getType()) {
            case BOOLEAN: {
                BooleanVariableFilterDataDto booleanVarDto = (BooleanVariableFilterDataDto)dto;
                queryBuilder = this.createBooleanQueryBuilder(booleanVarDto);
                break;
            }
            case STRING: {
                StringVariableFilterDataDto stringVarDto = (StringVariableFilterDataDto)dto;
                queryBuilder = this.createStringQueryBuilder(stringVarDto);
                break;
            }
            case INTEGER: 
            case DOUBLE: 
            case SHORT: 
            case LONG: {
                OperatorMultipleValuesVariableFilterDataDto numericVarDto = (OperatorMultipleValuesVariableFilterDataDto)dto;
                queryBuilder = this.createNumericQueryBuilder(numericVarDto);
                break;
            }
            case DATE: {
                DateVariableFilterDataDto dateVarDto = (DateVariableFilterDataDto)dto;
                queryBuilder = this.createDateQueryBuilder(dateVarDto, timezone);
                break;
            }
            default: {
                this.logger.warn("Could not filter for variables! Type [{}] is not supported for variable filters. Ignoring filter.", (Object)dto.getType());
            }
        }
        return queryBuilder;
    }

    @Override
    protected Query.Builder createContainsOneOfTheGivenStringsQueryBuilder(StringVariableFilterDataDto dto) {
        Query.Builder containOneOfTheGivenStrings = this.createContainsOneOfTheGivenStringsQueryBuilder(dto.getName(), ((OperatorMultipleValuesFilterDataDto)dto.getData()).getValues());
        if (FilterOperator.NOT_CONTAINS.equals((Object)((OperatorMultipleValuesFilterDataDto)dto.getData()).getOperator())) {
            Query.Builder builder = new Query.Builder();
            builder.bool(b -> b.mustNot(containOneOfTheGivenStrings.build(), new Query[0]));
            return builder;
        }
        return containOneOfTheGivenStrings;
    }

    @Override
    protected Query.Builder createContainsOneOfTheGivenStringsQueryBuilder(String variableId, List<String> values) {
        Query.Builder builder = new Query.Builder();
        builder.bool(b -> {
            values.stream().filter(Objects::nonNull).forEach(stringVal -> b.should(this.createContainsGivenStringQuery(variableId, (String)stringVal).build(), new Query[0]));
            boolean hasNullValues = values.stream().anyMatch(Objects::isNull);
            if (hasNullValues) {
                b.should(this.createFilterForUndefinedOrNullQueryBuilder(variableId).build(), new Query[0]);
            }
            return b;
        });
        return builder;
    }

    @Override
    protected Query.Builder createContainsGivenStringQuery(String variableId, String valueToContain) {
        Query.Builder builder = new Query.Builder();
        BoolQuery.Builder containsVariableString = new BoolQuery.Builder();
        containsVariableString.must(m -> m.term(t -> t.field(this.getVariableIdField()).value(variableId)));
        String lowerCaseValue = valueToContain.toLowerCase(Locale.ENGLISH);
        Query filter = lowerCaseValue.length() > 10 ? Query.of(q -> q.wildcard(w -> w.field(DecisionVariableHelper.getValueSearchField(this.getVariablePath(), "lowercaseField")).wildcard(DecisionVariableHelper.buildWildcardQuery(lowerCaseValue)))) : Query.of(q -> q.term(t -> t.field(DecisionVariableHelper.getValueSearchField(this.getVariablePath(), "nGramField")).value(lowerCaseValue)));
        containsVariableString.must(filter, new Query[0]);
        builder.nested(n -> n.path(this.getVariablePath()).query(q -> q.bool(containsVariableString.build())).scoreMode(ChildScoreMode.None));
        return builder;
    }

    @Override
    protected Query.Builder createEqualsOneOrMoreValuesQueryBuilder(OperatorMultipleValuesVariableFilterDataDto dto) {
        Query.Builder variableFilterBuilder = this.createMultiValueVariableFilterQuery(this.getVariableId((VariableFilterDataDto<?>)dto), dto.getType(), ((OperatorMultipleValuesFilterDataDto)dto.getData()).getValues());
        if (FilterOperator.NOT_IN.equals((Object)((OperatorMultipleValuesFilterDataDto)dto.getData()).getOperator())) {
            Query.Builder builder = new Query.Builder();
            builder.bool(b -> b.mustNot(variableFilterBuilder.build(), new Query[0]));
            return builder;
        }
        return variableFilterBuilder;
    }

    @Override
    protected Query.Builder createBooleanQueryBuilder(BooleanVariableFilterDataDto dto) {
        ValidationHelper.ensureCollectionNotEmpty("boolean filter value", ((BooleanVariableFilterSubDataDto)dto.getData()).getValues());
        return this.createMultiValueVariableFilterQuery(this.getVariableId((VariableFilterDataDto<?>)dto), dto.getType(), ((BooleanVariableFilterSubDataDto)dto.getData()).getValues());
    }

    private Query.Builder createMultiValueVariableFilterQuery(String variableId, VariableType variableType, List<?> values) {
        Query.Builder builder = new Query.Builder();
        builder.bool(b -> {
            b.minimumShouldMatch("1");
            String nestedVariableIdFieldLabel = this.getVariableIdField();
            String nestedVariableValueFieldLabel = this.getVariableValueFieldForType(variableType);
            List nonNullValues = values.stream().filter(Objects::nonNull).map(FieldValue::of).collect(Collectors.toList());
            if (!nonNullValues.isEmpty()) {
                b.should(s -> s.nested(n -> n.path(this.getVariablePath()).query(q -> q.bool(bb -> bb.must(m -> m.term(t -> t.field(nestedVariableIdFieldLabel).value(variableId))).must(m -> m.terms(t -> t.field(nestedVariableValueFieldLabel).terms(tt -> tt.value(nonNullValues)))))).scoreMode(ChildScoreMode.None)));
            }
            if (nonNullValues.size() < values.size()) {
                b.should(this.createFilterForUndefinedOrNullQueryBuilder(variableId).build(), new Query[0]);
            }
            return b;
        });
        return builder;
    }

    @Override
    protected Query.Builder createNumericQueryBuilder(OperatorMultipleValuesVariableFilterDataDto dto) {
        OperatorMultipleValuesVariableFilterDataDtoUtil.validateMultipleValuesFilterDataDto(dto);
        String nestedVariableValueFieldLabel = this.getVariableValueFieldForType(dto.getType());
        OperatorMultipleValuesFilterDataDto data = (OperatorMultipleValuesFilterDataDto)dto.getData();
        Query.Builder builder = new Query.Builder();
        Supplier<BoolQuery.Builder> supplier = () -> new BoolQuery.Builder().must(m -> m.term(t -> t.field(this.getVariableIdField()).value(this.getVariableId((VariableFilterDataDto<?>)dto))));
        if (data.getValues().isEmpty()) {
            this.logger.warn("Could not filter for variables! No values provided for operator [{}] and type [{}]. Ignoring filter.", (Object)data.getOperator(), (Object)dto.getType());
            builder.bool(supplier.get().build());
            return builder;
        }
        Object value = OperatorMultipleValuesVariableFilterDataDtoUtil.retrieveValue(dto);
        switch (data.getOperator()) {
            case IN: 
            case NOT_IN: {
                return this.createEqualsOneOrMoreValuesQueryBuilder(dto);
            }
            case LESS_THAN: {
                builder.nested(n -> n.path(this.getVariablePath()).scoreMode(ChildScoreMode.None).query(arg_0 -> DecisionVariableQueryFilterES.lambda$createNumericQueryBuilder$29((Supplier)supplier, nestedVariableValueFieldLabel, value, arg_0)));
                break;
            }
            case GREATER_THAN: {
                builder.nested(n -> n.path(this.getVariablePath()).scoreMode(ChildScoreMode.None).query(arg_0 -> DecisionVariableQueryFilterES.lambda$createNumericQueryBuilder$33((Supplier)supplier, nestedVariableValueFieldLabel, value, arg_0)));
                break;
            }
            case LESS_THAN_EQUALS: {
                builder.nested(n -> n.path(this.getVariablePath()).scoreMode(ChildScoreMode.None).query(arg_0 -> DecisionVariableQueryFilterES.lambda$createNumericQueryBuilder$37((Supplier)supplier, nestedVariableValueFieldLabel, value, arg_0)));
                break;
            }
            case GREATER_THAN_EQUALS: {
                builder.nested(n -> n.path(this.getVariablePath()).scoreMode(ChildScoreMode.None).query(arg_0 -> DecisionVariableQueryFilterES.lambda$createNumericQueryBuilder$41((Supplier)supplier, nestedVariableValueFieldLabel, value, arg_0)));
                break;
            }
            default: {
                builder.nested(n -> n.path(this.getVariablePath()).scoreMode(ChildScoreMode.None).query(arg_0 -> DecisionVariableQueryFilterES.lambda$createNumericQueryBuilder$43((Supplier)supplier, arg_0)));
                this.logger.warn("Could not filter for variables! Operator [{}] is not supported for type [{}]. Ignoring filter.", (Object)data.getOperator(), (Object)dto.getType());
            }
        }
        return builder;
    }

    @Override
    protected Query.Builder createDateQueryBuilder(DateVariableFilterDataDto dto, ZoneId timezone) {
        Query.Builder builder = new Query.Builder();
        builder.bool(b -> {
            b.minimumShouldMatch("1");
            if (((DateFilterDataDto)dto.getData()).isIncludeUndefined()) {
                b.should(this.createFilterForUndefinedOrNullQueryBuilder(this.getVariableId((VariableFilterDataDto<?>)dto)).build(), new Query[0]);
            } else if (((DateFilterDataDto)dto.getData()).isExcludeUndefined()) {
                b.should(this.createExcludeUndefinedOrNullQueryBuilder(this.getVariableId((VariableFilterDataDto<?>)dto)).build(), new Query[0]);
            }
            BoolQuery.Builder dateValueFilterQuery = new BoolQuery.Builder().must(m -> m.term(t -> t.field(this.getVariableIdField()).value(this.getVariableId((VariableFilterDataDto<?>)dto))));
            DateFilterQueryUtilES.addFilters(dateValueFilterQuery, Collections.singletonList((DateFilterDataDto)dto.getData()), this.getVariableValueFieldForType(dto.getType()), timezone);
            BoolQuery build = dateValueFilterQuery.build();
            if (!build.filter().isEmpty()) {
                b.should(s -> s.nested(n -> n.path(this.getVariablePath()).query(q -> q.bool(build)).scoreMode(ChildScoreMode.None)));
            }
            return b;
        });
        return builder;
    }

    private Query.Builder createFilterForUndefinedOrNullQueryBuilder(String variableId) {
        Query.Builder builder = new Query.Builder();
        builder.bool(b -> b.should(s -> s.bool(bb -> bb.mustNot(m -> m.nested(n -> n.path(this.getVariablePath()).query(q -> q.term(t -> t.field(this.getVariableIdField()).value(variableId))).scoreMode(ChildScoreMode.None))))).should(s -> s.bool(bb -> bb.must(m -> m.nested(n -> n.path(this.getVariablePath()).query(q -> q.bool(bbb -> bbb.must(mm -> mm.term(t -> t.field(this.getVariableIdField()).value(variableId))).mustNot(mn -> mn.exists(e -> e.field(DecisionVariableHelper.getVariableStringValueField(this.getVariablePath())))))).scoreMode(ChildScoreMode.None))))).minimumShouldMatch("1"));
        return builder;
    }

    private Query.Builder createExcludeUndefinedOrNullQueryBuilder(String variableId) {
        Query.Builder builder = new Query.Builder();
        builder.bool(b -> b.must(m -> m.nested(n -> n.path(this.getVariablePath()).query(q -> q.bool(bb -> bb.must(mm -> mm.term(t -> t.field(this.getVariableIdField()).value(variableId))).must(mm -> mm.exists(e -> e.field(DecisionVariableHelper.getVariableStringValueField(this.getVariablePath())))))).scoreMode(ChildScoreMode.None))));
        return builder;
    }

    private String getVariableId(VariableFilterDataDto<?> dto) {
        return dto.getName();
    }

    private String getVariableValueFieldForType(VariableType type) {
        return DecisionVariableHelper.getVariableValueFieldForType(this.getVariablePath(), type);
    }

    private String getVariableIdField() {
        return DecisionVariableHelper.getVariableClauseIdField(this.getVariablePath());
    }

    private static /* synthetic */ ObjectBuilder lambda$createNumericQueryBuilder$43(Supplier supplier, Query.Builder q) {
        return q.bool(((BoolQuery.Builder)supplier.get()).build());
    }

    private static /* synthetic */ ObjectBuilder lambda$createNumericQueryBuilder$41(Supplier supplier, String nestedVariableValueFieldLabel, Object value, Query.Builder q) {
        return q.bool(((BoolQuery.Builder)supplier.get()).must(m -> m.range(r -> r.field(nestedVariableValueFieldLabel).gte(JsonData.of((Object)value)))).build());
    }

    private static /* synthetic */ ObjectBuilder lambda$createNumericQueryBuilder$37(Supplier supplier, String nestedVariableValueFieldLabel, Object value, Query.Builder q) {
        return q.bool(((BoolQuery.Builder)supplier.get()).must(m -> m.range(r -> r.field(nestedVariableValueFieldLabel).lte(JsonData.of((Object)value)))).build());
    }

    private static /* synthetic */ ObjectBuilder lambda$createNumericQueryBuilder$33(Supplier supplier, String nestedVariableValueFieldLabel, Object value, Query.Builder q) {
        return q.bool(((BoolQuery.Builder)supplier.get()).must(m -> m.range(r -> r.field(nestedVariableValueFieldLabel).gt(JsonData.of((Object)value)))).build());
    }

    private static /* synthetic */ ObjectBuilder lambda$createNumericQueryBuilder$29(Supplier supplier, String nestedVariableValueFieldLabel, Object value, Query.Builder q) {
        return q.bool(((BoolQuery.Builder)supplier.get()).must(m -> m.range(r -> r.field(nestedVariableValueFieldLabel).lt(JsonData.of((Object)value)))).build());
    }
}

