/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.transport.TransportOptions;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.schema.ElasticSearchSchemaManager;
import io.camunda.optimize.service.db.es.schema.TransportOptionsProvider;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import io.camunda.optimize.service.util.mapper.ObjectMapperFactory;
import io.camunda.optimize.upgrade.es.ElasticsearchClientBuilder;
import io.camunda.search.connect.plugin.PluginRepository;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Conditional(value={ElasticSearchCondition.class})
public final class OptimizeElasticsearchClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizeElasticsearchClientFactory.class);

    private OptimizeElasticsearchClientFactory() {
    }

    public static OptimizeElasticsearchClient create(ConfigurationService configurationService, OptimizeIndexNameService optimizeIndexNameService, ElasticSearchSchemaManager elasticSearchSchemaManager, BackoffCalculator backoffCalculator, PluginRepository pluginRepository) throws IOException {
        LOG.info("Initializing Elasticsearch rest client...");
        TransportOptionsProvider transportOptionsProvider = new TransportOptionsProvider(configurationService);
        ElasticsearchClient build = ElasticsearchClientBuilder.build((ConfigurationService)configurationService, (ObjectMapper)ObjectMapperFactory.OPTIMIZE_MAPPER, (PluginRepository)pluginRepository);
        boolean clusterTaskCheckingEnabled = configurationService.getElasticSearchConfiguration().getConnection().isClusterTaskCheckingEnabled();
        if (clusterTaskCheckingEnabled) {
            OptimizeElasticsearchClientFactory.waitForElasticsearch(build, backoffCalculator, transportOptionsProvider.getTransportOptions());
            LOG.info("Elasticsearch client has successfully been started");
        } else {
            LOG.info("Cluster task checking disabled, not waiting for Elasticsearch to start");
        }
        OptimizeElasticsearchClient prefixedClient = new OptimizeElasticsearchClient(ElasticsearchClientBuilder.restClient((ConfigurationService)configurationService, (PluginRepository)pluginRepository), ObjectMapperFactory.OPTIMIZE_MAPPER, build, optimizeIndexNameService, transportOptionsProvider);
        elasticSearchSchemaManager.validateDatabaseMetadata(prefixedClient);
        boolean initSchemaEnabled = configurationService.getElasticSearchConfiguration().getConnection().isInitSchemaEnabled();
        if (initSchemaEnabled) {
            elasticSearchSchemaManager.initializeSchema(prefixedClient);
        } else {
            LOG.info("Schema initialization disabled, skipping");
        }
        return prefixedClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForElasticsearch(ElasticsearchClient esClient, BackoffCalculator backoffCalculator, TransportOptions requestOptions) throws IOException {
        boolean isConnected = false;
        int connectionAttempts = 0;
        while (!isConnected) {
            ++connectionAttempts;
            try {
                isConnected = OptimizeElasticsearchClientFactory.getNumberOfClusterNodes(esClient, requestOptions) > 0;
            }
            catch (Exception e) {
                String errorMessage = "Can't connect to any Elasticsearch node. Please check the connection!";
                if (connectionAttempts < 10) {
                    LOG.warn("Can't connect to any Elasticsearch node. Please check the connection!");
                    continue;
                }
                LOG.error("Can't connect to any Elasticsearch node. Please check the connection!", (Throwable)e);
            }
            finally {
                if (isConnected) continue;
                long sleepTime = backoffCalculator.calculateSleepTime();
                LOG.info("No Elasticsearch nodes available, waiting [{}] ms to retry connecting", (Object)sleepTime);
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    LOG.warn("Got interrupted while waiting to retry connecting to Elasticsearch.", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static int getNumberOfClusterNodes(ElasticsearchClient esClient, TransportOptions requestOptions) throws IOException {
        return esClient.withTransportOptions(requestOptions).cluster().health(c -> c).numberOfNodes();
    }
}

