/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.dashboard;

import io.camunda.optimize.dto.optimize.query.EntityIdResponseDto;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.dashboard.InstantDashboardDataDto;
import io.camunda.optimize.dto.optimize.query.dashboard.tile.DashboardReportTileDto;
import io.camunda.optimize.dto.optimize.query.dashboard.tile.DashboardTileType;
import io.camunda.optimize.dto.optimize.query.definition.DefinitionWithTenantIdsDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityType;
import io.camunda.optimize.dto.optimize.query.report.single.ReportDataDefinitionDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizedDashboardDefinitionResponseDto;
import io.camunda.optimize.dto.optimize.rest.export.OptimizeEntityExportDto;
import io.camunda.optimize.dto.optimize.rest.export.dashboard.DashboardDefinitionExportDto;
import io.camunda.optimize.dto.optimize.rest.export.report.SingleProcessReportDefinitionExportDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.dashboard.DashboardService;
import io.camunda.optimize.service.db.reader.InstantDashboardMetadataReader;
import io.camunda.optimize.service.db.writer.InstantDashboardMetadataWriter;
import io.camunda.optimize.service.entities.EntityImportService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.util.FilenameValidatorUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class InstantPreviewDashboardService {
    public static final String INSTANT_PREVIEW_DASHBOARD_TEMPLATES_PATH = "instant_preview_dashboards/";
    public static final String EXTERNAL_STATIC_RESOURCES_SUBPATH = "/external/static/instant_preview_dashboards/";
    public static final String SRC_FIELD = "src";
    public static final String ALTTEXT_FIELD = "altText";
    public static final String TYPE_FIELD = "type";
    public static final String TYPE_IMAGE_VALUE = "image";
    private static final Logger LOG = LoggerFactory.getLogger(InstantPreviewDashboardService.class);
    protected final ConfigurationService configurationService;
    private final DashboardService dashboardService;
    private final ReportService reportService;
    private final InstantDashboardMetadataReader instantDashboardMetadataReader;
    private final InstantDashboardMetadataWriter instantDashboardMetadataWriter;
    private final EntityImportService entityImportService;
    private final DefinitionService definitionService;
    private final HashMap<String, Long> templateChecksums;

    public InstantPreviewDashboardService(DashboardService dashboardService, ReportService reportService, InstantDashboardMetadataReader instantDashboardMetadataReader, InstantDashboardMetadataWriter instantDashboardMetadataWriter, EntityImportService entityImportService, DefinitionService definitionService, ConfigurationService configurationService, HashMap<String, Long> templateChecksums) {
        this.dashboardService = dashboardService;
        this.reportService = reportService;
        this.instantDashboardMetadataReader = instantDashboardMetadataReader;
        this.instantDashboardMetadataWriter = instantDashboardMetadataWriter;
        this.entityImportService = entityImportService;
        this.definitionService = definitionService;
        this.configurationService = configurationService;
        this.templateChecksums = templateChecksums;
    }

    public AuthorizedDashboardDefinitionResponseDto getInstantPreviewDashboard(String processDefinitionKey, String dashboardJsonTemplate, String userId) {
        String emptySafeDashboardTemplate = StringUtils.isEmpty((CharSequence)dashboardJsonTemplate) ? "template1.json" : dashboardJsonTemplate;
        String processedTemplateName = emptySafeDashboardTemplate.replace(".", "");
        Optional<String> dashboardId = this.instantDashboardMetadataReader.getInstantDashboardIdFor(processDefinitionKey, processedTemplateName);
        if (dashboardId.isPresent()) {
            return this.dashboardService.getDashboardDefinition(dashboardId.get(), userId);
        }
        LOG.info("Instant preview dashboard for process definition [{}] and template [{}} does not exist yet, creating it!", (Object)processDefinitionKey, (Object)emptySafeDashboardTemplate);
        return this.createInstantPreviewDashboard(processDefinitionKey, emptySafeDashboardTemplate).map(dashboard -> this.dashboardService.getDashboardDefinition(dashboard.getDashboardId(), userId)).orElseThrow(() -> new NotFoundException(String.format("Dashboard does not exist! Either the process definition [%s] or the template [%s] does not exist", processDefinitionKey, emptySafeDashboardTemplate)));
    }

    public Optional<InstantDashboardDataDto> createInstantPreviewDashboard(String processDefinitionKey, String dashboardJsonTemplate) {
        String emptySafeDashboardTemplate = StringUtils.isEmpty((CharSequence)dashboardJsonTemplate) ? "template1.json" : dashboardJsonTemplate;
        InstantDashboardDataDto instantDashboardDataDto = new InstantDashboardDataDto();
        instantDashboardDataDto.setTemplateName(emptySafeDashboardTemplate);
        instantDashboardDataDto.setProcessDefinitionKey(processDefinitionKey);
        return this.setupInstantPreviewDashboard(instantDashboardDataDto.getTemplateName(), processDefinitionKey).map(dashboardId -> {
            instantDashboardDataDto.setDashboardId(dashboardId);
            instantDashboardDataDto.setTemplateHash(this.templateChecksums.get(emptySafeDashboardTemplate).longValue());
            this.instantDashboardMetadataWriter.saveInstantDashboard(instantDashboardDataDto);
            return instantDashboardDataDto;
        });
    }

    public static void findAndConvertTileContent(Object node, String fieldType, BiConsumerWithParameters<Map<String, Object>, String> transformFunction, String additionalParameterValue) {
        if (node instanceof HashMap) {
            HashMap tileConfigurationElement = (HashMap)node;
            if (fieldType.equals(tileConfigurationElement.getOrDefault(TYPE_FIELD, ""))) {
                transformFunction.accept(tileConfigurationElement, additionalParameterValue);
            } else {
                tileConfigurationElement.forEach((key, value) -> InstantPreviewDashboardService.findAndConvertTileContent(value, fieldType, transformFunction, additionalParameterValue));
            }
        } else if (node instanceof ArrayList) {
            ArrayList list = (ArrayList)node;
            list.forEach(item -> InstantPreviewDashboardService.findAndConvertTileContent(item, fieldType, transformFunction, additionalParameterValue));
        }
    }

    private Optional<String> setupInstantPreviewDashboard(String dashboardJsonTemplate, String processDefinitionKey) {
        Optional<Set<OptimizeEntityExportDto>> exportDtos = this.readAndProcessDashboardTemplate(dashboardJsonTemplate);
        return exportDtos.flatMap(exportDtoSet -> this.createReportsAndAddToDashboard((Set<OptimizeEntityExportDto>)exportDtoSet, processDefinitionKey));
    }

    private Optional<String> createReportsAndAddToDashboard(Set<OptimizeEntityExportDto> exportDtos, String processDefinitionKey) {
        Optional<DefinitionWithTenantIdsDto> processDefinitionWithTenants = this.definitionService.getProcessDefinitionWithTenants(processDefinitionKey);
        processDefinitionWithTenants.ifPresentOrElse(processDefinition -> exportDtos.stream().filter(SingleProcessReportDefinitionExportDto.class::isInstance).forEach(reportEntity -> {
            SingleProcessReportDefinitionExportDto singleReport = (SingleProcessReportDefinitionExportDto)reportEntity;
            singleReport.getData().setInstantPreviewReport(true);
            singleReport.getData().setDefinitions(List.of(new ReportDataDefinitionDto(processDefinitionKey, processDefinition.getName(), List.of("all"), processDefinition.getTenantIds())));
        }), () -> LOG.warn("Could not retrieve process definition data for {}", (Object)processDefinitionKey));
        exportDtos.stream().filter(DashboardDefinitionExportDto.class::isInstance).forEach(dashboardEntity -> {
            DashboardDefinitionExportDto dashboardData = (DashboardDefinitionExportDto)dashboardEntity;
            this.processAllImageUrlsInTiles(dashboardData.getTiles());
            dashboardData.setInstantPreviewDashboard(true);
        });
        List<EntityIdResponseDto> importedEntities = this.entityImportService.importInstantPreviewEntities(null, exportDtos);
        return importedEntities.stream().filter(entity -> entity.getEntityType() == EntityType.DASHBOARD).findFirst().map(EntityIdResponseDto::getId);
    }

    public void processAllImageUrlsInTiles(List<DashboardReportTileDto> tiles) {
        tiles.forEach(tile -> {
            if (tile.getType() == DashboardTileType.TEXT) {
                Map textTileConfiguration = (Map)tile.getConfiguration();
                Object clusterId = this.configurationService.getAuthConfiguration().getCloudAuthConfiguration().getClusterId();
                if (StringUtils.isNotEmpty((CharSequence)clusterId)) {
                    clusterId = "/" + (String)clusterId;
                }
                InstantPreviewDashboardService.findAndConvertTileContent(textTileConfiguration, TYPE_IMAGE_VALUE, this::convertAbsoluteUrlsToRelative, (String)clusterId);
            }
        });
    }

    private void convertAbsoluteUrlsToRelative(Map<String, Object> textTileConfigElement, String clusterId) {
        String srcValue = (String)textTileConfigElement.get(SRC_FIELD);
        String altTextValue = (String)textTileConfigElement.get(ALTTEXT_FIELD);
        String srcValueFileName = srcValue.substring(srcValue.lastIndexOf(47) + 1);
        textTileConfigElement.put(SRC_FIELD, this.createContextPathAwarePath(clusterId + EXTERNAL_STATIC_RESOURCES_SUBPATH + srcValueFileName));
        String altTextValueFileName = altTextValue.substring(altTextValue.lastIndexOf(47) + 1);
        textTileConfigElement.put(ALTTEXT_FIELD, this.createContextPathAwarePath(clusterId + EXTERNAL_STATIC_RESOURCES_SUBPATH + altTextValueFileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Set<OptimizeEntityExportDto>> readAndProcessDashboardTemplate(String dashboardJsonTemplateFilename) {
        FilenameValidatorUtil.validateFilename(dashboardJsonTemplateFilename);
        String fullyQualifiedPath = INSTANT_PREVIEW_DASHBOARD_TEMPLATES_PATH + dashboardJsonTemplateFilename;
        try (InputStream dashboardTemplate = this.getClass().getClassLoader().getResourceAsStream(fullyQualifiedPath);){
            if (dashboardTemplate != null) {
                String exportedDtoJson = new String(dashboardTemplate.readAllBytes(), StandardCharsets.UTF_8);
                Long checksum = InstantPreviewDashboardService.getChecksumCRC32(exportedDtoJson);
                Set<OptimizeEntityExportDto> valueToBeReturned = this.entityImportService.readExportDtoOrFailIfInvalid(exportedDtoJson);
                this.templateChecksums.put(dashboardJsonTemplateFilename, checksum);
                Optional<Set<OptimizeEntityExportDto>> optional = Optional.of(valueToBeReturned);
                return optional;
            }
            LOG.error("Could not read dashboard template from " + fullyQualifiedPath);
            return Optional.empty();
        }
        catch (IOException e) {
            LOG.error("Could not read dashboard template from " + fullyQualifiedPath, (Throwable)e);
        }
        return Optional.empty();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void deleteInstantPreviewDashboardsAndEntitiesForChangedTemplates() {
        List<Long> templateFileChecksums = this.getCurrentFileChecksums();
        try {
            List<String> dashboardsToDelete = this.instantDashboardMetadataWriter.deleteOutdatedTemplateEntriesAndGetExistingDashboardIds(templateFileChecksums);
            for (String dashboardIdToDelete : dashboardsToDelete) {
                DashboardDefinitionRestDto dashboardDefinition = this.dashboardService.getDashboardDefinitionAsService(dashboardIdToDelete);
                if (!dashboardDefinition.isInstantPreviewDashboard()) continue;
                Set reportsToDelete = dashboardDefinition.getTileIds();
                for (String reportId : reportsToDelete) {
                    this.reportService.deleteManagementOrInstantPreviewReport(reportId);
                }
                this.dashboardService.deleteDashboard(dashboardIdToDelete);
            }
        }
        catch (Exception e) {
            LOG.error("There was an error deleting data from an outdated Instant preview dashboard", (Throwable)e);
        }
    }

    public List<Long> getCurrentFileChecksums() {
        String currentTemplate = "template1.json";
        ArrayList<Long> fileChecksums = new ArrayList<Long>();
        InputStream templateInputStream = this.getClass().getClassLoader().getResourceAsStream(INSTANT_PREVIEW_DASHBOARD_TEMPLATES_PATH + currentTemplate);
        while (templateInputStream != null) {
            try {
                fileChecksums.add(InstantPreviewDashboardService.getChecksumCRC32(templateInputStream, 8192));
            }
            catch (IOException e) {
                LOG.error("Could not generate checksum for template [{}]", (Object)currentTemplate);
            }
            currentTemplate = InstantPreviewDashboardService.incrementFileName(currentTemplate);
            templateInputStream = this.getClass().getClassLoader().getResourceAsStream(INSTANT_PREVIEW_DASHBOARD_TEMPLATES_PATH + currentTemplate);
        }
        return fileChecksums;
    }

    public static long getChecksumCRC32(InputStream stream, int bufferSize) throws IOException {
        CheckedInputStream checkedInputStream = new CheckedInputStream(stream, new CRC32());
        byte[] buffer = new byte[bufferSize];
        while (checkedInputStream.read(buffer, 0, buffer.length) >= 0) {
        }
        return checkedInputStream.getChecksum().getValue();
    }

    public static long getChecksumCRC32(String input) {
        byte[] bytes = input.getBytes();
        CRC32 checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        return checksum.getValue();
    }

    private static String incrementFileName(String fileName) {
        String fileNameWithoutExtension = fileName.substring(0, fileName.lastIndexOf("."));
        String fileExtension = fileName.substring(fileName.lastIndexOf("."));
        Pattern pattern = Pattern.compile("(.*?)(\\d+)$");
        Matcher matcher = pattern.matcher(fileNameWithoutExtension);
        if (matcher.find()) {
            int suffix;
            String prefix = matcher.group(1);
            try {
                suffix = Integer.parseInt(matcher.group(2)) + 1;
            }
            catch (NumberFormatException exception) {
                throw new OptimizeRuntimeException("Error while incrementing file name");
            }
            return prefix + suffix + fileExtension;
        }
        return fileNameWithoutExtension + "1" + fileExtension;
    }

    private String createContextPathAwarePath(String subPath) {
        return this.configurationService.getContextPath().map(contextPath -> contextPath + subPath).orElse(subPath);
    }

    @FunctionalInterface
    public static interface BiConsumerWithParameters<T, U> {
        public void accept(T var1, U var2);
    }
}

