/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.cleanup;

import java.time.OffsetDateTime;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CleanupService {
    private static final Logger LOG = LoggerFactory.getLogger(CleanupService.class);

    public abstract boolean isEnabled();

    public abstract void doCleanup(OffsetDateTime var1);

    public void verifyConfiguredKeysAreKnownDefinitionKeys(Set<String> knownDefinitionKeys, Set<String> specificDefinitionConfigKeys) {
        Set knownConfiguredKeys = specificDefinitionConfigKeys.stream().filter(knownDefinitionKeys::contains).collect(Collectors.toSet());
        specificDefinitionConfigKeys.removeAll(knownConfiguredKeys);
        if (!specificDefinitionConfigKeys.isEmpty()) {
            LOG.warn("History Cleanup Configuration contains definition keys for which there is no definition imported yet. The keys without a match in the database are: " + String.valueOf(specificDefinitionConfigKeys));
        }
    }
}

