/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.cleanup;

import io.camunda.optimize.service.AbstractScheduledService;
import io.camunda.optimize.service.cleanup.CleanupService;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationReloadable;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.cleanup.CleanupConfiguration;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.OffsetDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@Component
public class CleanupScheduler
extends AbstractScheduledService
implements ConfigurationReloadable {
    private static final Logger LOG = LoggerFactory.getLogger(CleanupScheduler.class);
    private final ConfigurationService configurationService;
    private final List<CleanupService> cleanupServices;

    public CleanupScheduler(ConfigurationService configurationService, List<CleanupService> cleanupServices) {
        this.configurationService = configurationService;
        this.cleanupServices = cleanupServices;
    }

    @PostConstruct
    public void init() {
        LOG.info("Initializing OptimizeCleanupScheduler");
        this.getCleanupConfiguration().validate();
        if (this.getCleanupConfiguration().isEnabled()) {
            this.startCleanupScheduling();
        } else {
            this.stopCleanupScheduling();
        }
    }

    public synchronized void startCleanupScheduling() {
        LOG.info("Starting cleanup scheduling");
        this.startScheduling();
    }

    @PreDestroy
    public synchronized void stopCleanupScheduling() {
        LOG.info("Stopping cleanup scheduling");
        this.stopScheduling();
    }

    @Override
    public void run() {
        this.runCleanup();
    }

    protected CronTrigger createScheduleTrigger() {
        return new CronTrigger(this.getCleanupConfiguration().getCronTrigger());
    }

    public void runCleanup() {
        LOG.info("Running optimize history cleanup...");
        OffsetDateTime startTime = LocalDateUtil.getCurrentDateTime();
        this.cleanupServices.stream().filter(CleanupService::isEnabled).forEach(optimizeCleanupService -> {
            LOG.info("Running CleanupService {}", (Object)optimizeCleanupService.getClass().getSimpleName());
            try {
                optimizeCleanupService.doCleanup(startTime);
            }
            catch (Exception e) {
                LOG.error("Execution of cleanupService {} failed", (Object)optimizeCleanupService.getClass().getSimpleName(), (Object)e);
            }
        });
        long durationSeconds = OffsetDateTime.now().minusSeconds(startTime.toEpochSecond()).toEpochSecond();
        LOG.info("Finished optimize history cleanup in {}s", (Object)durationSeconds);
    }

    public List<CleanupService> getCleanupServices() {
        return this.cleanupServices;
    }

    public void reloadConfiguration(ApplicationContext context) {
        this.init();
    }

    protected CleanupConfiguration getCleanupConfiguration() {
        return this.configurationService.getCleanupServiceConfiguration();
    }
}

