/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import io.camunda.optimize.dto.optimize.SettingsDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.service.db.reader.SettingsReader;
import io.camunda.optimize.service.db.writer.SettingsWriter;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SettingsService {
    private static final Logger LOG = LoggerFactory.getLogger(SettingsService.class);
    private final SettingsReader settingsReader;
    private final SettingsWriter settingsWriter;
    private final AbstractIdentityService identityService;
    private final ConfigurationService configurationService;

    public SettingsService(SettingsReader settingsReader, SettingsWriter settingsWriter, AbstractIdentityService identityService, ConfigurationService configurationService) {
        this.settingsReader = settingsReader;
        this.settingsWriter = settingsWriter;
        this.identityService = identityService;
        this.configurationService = configurationService;
    }

    public SettingsDto getSettings() {
        return this.settingsReader.getSettings().orElse(SettingsDto.builder().sharingEnabled(Boolean.valueOf(this.configurationService.getSharingEnabled())).build());
    }

    public void setSettings(SettingsDto settingsDto) {
        settingsDto.setLastModified(LocalDateUtil.getCurrentDateTime());
        settingsDto.getSharingEnabled().ifPresent(arg_0 -> ((ConfigurationService)this.configurationService).setSharingEnabled(arg_0));
        this.settingsWriter.upsertSettings(settingsDto);
    }

    public void setSettings(String userId, SettingsDto settingsDto) {
        this.validateUserAuthorizedToConfigureSettingsOrFail(userId);
        settingsDto.setLastModified(LocalDateUtil.getCurrentDateTime());
        this.settingsWriter.upsertSettings(settingsDto);
    }

    private void validateUserAuthorizedToConfigureSettingsOrFail(String userId) {
        throw new ForbiddenException(String.format("User [%s] is not authorized to configure settings.", userId));
    }
}

