/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security.oauth;

import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;

public class AudienceValidator
implements OAuth2TokenValidator<Jwt> {
    private final String expectedAudience;

    public AudienceValidator(String expectedAudience) {
        this.expectedAudience = expectedAudience;
    }

    public OAuth2TokenValidatorResult validate(Jwt jwt) {
        if (this.audienceIsValid()) {
            if (jwt.getAudience().contains(this.expectedAudience)) {
                return OAuth2TokenValidatorResult.success();
            }
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_token", "The required audience is missing", null)});
        }
        return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("bad_configuration", "The configured audience is invalid", null)});
    }

    private boolean audienceIsValid() {
        return this.expectedAudience != null && !this.expectedAudience.isEmpty();
    }
}

