/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security.cloud;

import io.camunda.optimize.rest.security.cloud.AuthorizationRequestCookieValueMapper;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;

public class HttpCookieOAuth2AuthorizationRequestRepository
implements AuthorizationRequestRepository<OAuth2AuthorizationRequest> {
    private static final String REQUEST_COOKIE_NAME = "oauth2_auth_request";
    private static final int REQUEST_COOKIE_MAX_AGE = 180;
    private final ConfigurationService configurationService;
    private final AuthorizationRequestCookieValueMapper authorizationRequestCookieValueMapper;

    public HttpCookieOAuth2AuthorizationRequestRepository(ConfigurationService configurationService, AuthorizationRequestCookieValueMapper authorizationRequestCookieValueMapper) {
        this.configurationService = configurationService;
        this.authorizationRequestCookieValueMapper = authorizationRequestCookieValueMapper;
    }

    public OAuth2AuthorizationRequest loadAuthorizationRequest(HttpServletRequest request) {
        return HttpCookieOAuth2AuthorizationRequestRepository.getAuthorizationRequestCookie(request).map(Cookie::getValue).map(this.authorizationRequestCookieValueMapper::deserialize).orElse(null);
    }

    public void saveAuthorizationRequest(OAuth2AuthorizationRequest authorizationRequest, HttpServletRequest request, HttpServletResponse response) {
        if (authorizationRequest == null) {
            HttpCookieOAuth2AuthorizationRequestRepository.deleteCookie(request, response);
            return;
        }
        HttpCookieOAuth2AuthorizationRequestRepository.addCookie(response, this.authorizationRequestCookieValueMapper.serialize(authorizationRequest), this.configurationService.getAuthConfiguration().getCookieConfiguration().resolveSecureFlagValue(request.getScheme()));
    }

    public OAuth2AuthorizationRequest removeAuthorizationRequest(HttpServletRequest request, HttpServletResponse response) {
        OAuth2AuthorizationRequest authorizationRequest = this.loadAuthorizationRequest(request);
        HttpCookieOAuth2AuthorizationRequestRepository.deleteCookie(request, response);
        return authorizationRequest;
    }

    private static void addCookie(HttpServletResponse response, String value, boolean secure) {
        Cookie cookie = new Cookie(REQUEST_COOKIE_NAME, value);
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        cookie.setMaxAge(180);
        cookie.setSecure(secure);
        response.addCookie(cookie);
    }

    private static void deleteCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(REQUEST_COOKIE_NAME)) continue;
                cookie.setValue("");
                cookie.setPath("/");
                cookie.setMaxAge(0);
                response.addCookie(cookie);
            }
        }
    }

    private static Optional<Cookie> getAuthorizationRequestCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(REQUEST_COOKIE_NAME)) continue;
                return Optional.of(cookie);
            }
        }
        return Optional.empty();
    }
}

