/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security.ccsm;

import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.JwtValidationException;

public class OptimizeStaticTokenDecoder
implements JwtDecoder {
    private final ConfigurationService configurationService;

    public OptimizeStaticTokenDecoder(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public Jwt decode(String token) throws JwtException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("typ", "SelfMade");
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("token", token);
        this.validateToken(token).ifPresent(error -> {
            throw new JwtValidationException("validationErrorString", List.of(error));
        });
        return new Jwt(token, Instant.now(), Instant.MAX, headers, claims);
    }

    private Optional<OAuth2Error> validateToken(String providedToken) {
        String expectedAccessToken = this.configurationService.getOptimizeApiConfiguration().getAccessToken();
        if (expectedAccessToken == null || expectedAccessToken.isEmpty()) {
            return Optional.of(new OAuth2Error("The config property 'api.accessToken' is not configured, therefore all public API requests will be blocked. Please check the documentation to set this property appropriately and restart the server."));
        }
        if (!expectedAccessToken.equals(providedToken)) {
            return Optional.of(new OAuth2Error("Provided authorization token is invalid."));
        }
        return Optional.empty();
    }
}

