/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security.ccsm;

import io.camunda.optimize.rest.security.AbstractSecurityConfigurerAdapter;
import io.camunda.optimize.rest.security.CustomPreAuthenticatedAuthenticationProvider;
import io.camunda.optimize.rest.security.ccsm.CCSMAuthenticationCookieFilter;
import io.camunda.optimize.rest.security.ccsm.OptimizeStaticTokenDecoder;
import io.camunda.optimize.rest.security.oauth.AudienceValidator;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.security.AuthCookieService;
import io.camunda.optimize.service.security.CCSMTokenService;
import io.camunda.optimize.service.security.SessionService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSMCondition;
import io.camunda.optimize.tomcat.CCSMRequestAdjustmentFilter;
import io.camunda.optimize.tomcat.OptimizeResourceConstants;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@Conditional(value={CCSMCondition.class})
public class CCSMSecurityConfigurerAdapter
extends AbstractSecurityConfigurerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(CCSMSecurityConfigurerAdapter.class);
    private final CCSMTokenService ccsmTokenService;

    public CCSMSecurityConfigurerAdapter(ConfigurationService configurationService, CustomPreAuthenticatedAuthenticationProvider customPreAuthenticatedAuthenticationProvider, SessionService sessionService, AuthCookieService authCookieService, CCSMTokenService ccsmTokenService) {
        super(configurationService, customPreAuthenticatedAuthenticationProvider, sessionService, authCookieService);
        this.ccsmTokenService = ccsmTokenService;
    }

    @Bean
    public FilterRegistrationBean registration(CCSMAuthenticationCookieFilter filter) {
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registration.setEnabled(false);
        return registration;
    }

    @Bean
    public CCSMAuthenticationCookieFilter ccsmAuthenticationCookieFilter(HttpSecurity http) throws Exception {
        return new CCSMAuthenticationCookieFilter(this.configurationService, this.ccsmTokenService, (AuthenticationManager)((AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class)).authenticationProvider((AuthenticationProvider)this.preAuthenticatedAuthenticationProvider).build());
    }

    @Bean
    FilterRegistrationBean<CCSMRequestAdjustmentFilter> requestAdjuster() {
        LOG.debug("Registering filter 'requestAdjuster' (CCSM)...");
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new CCSMRequestAdjustmentFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        return registration;
    }

    @Bean
    @Order(value=1)
    protected SecurityFilterChain configurePublicApi(HttpSecurity http) {
        HttpSecurity httpSecurityBuilder = http.securityMatchers(securityMatchers -> securityMatchers.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(PUBLIC_API_PATH), new AntPathRequestMatcher(CCSMSecurityConfigurerAdapter.createApiPath("/ingestion", "/variable"))}));
        return this.applyPublicApiOptions(httpSecurityBuilder);
    }

    @Bean
    @Order(value=2)
    protected SecurityFilterChain configureWebSecurity(HttpSecurity http) {
        try {
            return (SecurityFilterChain)super.configureGenericSecurityOptions(http).authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(CCSMSecurityConfigurerAdapter.createApiPath("/readyz"))})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(CCSMSecurityConfigurerAdapter.createApiPath("/authentication/callback"))})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/*.ico"), new AntPathRequestMatcher("/*.html"), new AntPathRequestMatcher("/static/*.js"), new AntPathRequestMatcher("/static/*.css"), new AntPathRequestMatcher("/static/*.html")})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/external/"), new AntPathRequestMatcher("/external/index*"), new AntPathRequestMatcher("/external/static/**"), new AntPathRequestMatcher("/external/*.js"), new AntPathRequestMatcher("/external/*.ico")})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(CCSMSecurityConfigurerAdapter.createApiPath("/external/**")), new AntPathRequestMatcher("/external/api/**")})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(CCSMSecurityConfigurerAdapter.createApiPath("/ui-configuration")), new AntPathRequestMatcher(CCSMSecurityConfigurerAdapter.createApiPath("/localization"))})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(OptimizeResourceConstants.ACTUATOR_ENDPOINT + "/**")})).permitAll().anyRequest()).authenticated()).addFilterBefore((Filter)this.ccsmAuthenticationCookieFilter(http), AbstractPreAuthenticatedProcessingFilter.class).exceptionHandling(exceptionHandling -> exceptionHandling.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED), (RequestMatcher)new AntPathRequestMatcher("/api/**")).defaultAuthenticationEntryPointFor(this::redirectToIdentity, (RequestMatcher)new AntPathRequestMatcher("/**"))).build();
        }
        catch (Exception e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    private String getAudienceFromConfiguration() {
        return this.configurationService.getOptimizeApiConfiguration().getAudience();
    }

    @Override
    protected JwtDecoder publicApiJwtDecoder() {
        return Optional.ofNullable(this.configurationService.getOptimizeApiConfiguration().getJwtSetUri()).map(this::createJwtDecoderWithAudience).orElseGet(() -> new OptimizeStaticTokenDecoder(this.configurationService));
    }

    private JwtDecoder createJwtDecoderWithAudience(String jwtSetUri) {
        NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwtSetUri).build();
        AudienceValidator audienceValidator = new AudienceValidator(this.getAudienceFromConfiguration());
        OAuth2TokenValidator combinedValidatorWithDefaults = JwtValidators.createDefaultWithValidators((OAuth2TokenValidator[])new OAuth2TokenValidator[]{audienceValidator});
        jwtDecoder.setJwtValidator(combinedValidatorWithDefaults);
        return jwtDecoder;
    }

    private void redirectToIdentity(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) throws IOException {
        String authorizeUri = this.ccsmTokenService.buildAuthorizeUri(CCSMSecurityConfigurerAdapter.buildAuthorizeCallbackBaseUri(request)).toString();
        response.sendRedirect(authorizeUri);
    }

    private static String buildAuthorizeCallbackBaseUri(HttpServletRequest req) {
        String redirectUri = req.getScheme() + "://" + req.getServerName();
        if (req.getScheme().equals("http") && req.getServerPort() != 80 || req.getScheme().equals("https") && req.getServerPort() != 443) {
            redirectUri = redirectUri + ":" + req.getServerPort();
        }
        return redirectUri + req.getContextPath();
    }
}

