/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security;

import io.camunda.optimize.rest.security.CustomPreAuthenticatedAuthenticationProvider;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.security.AuthCookieService;
import io.camunda.optimize.service.security.SessionService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.web.SecurityFilterChain;

public abstract class AbstractSecurityConfigurerAdapter {
    protected static final String DEEP_SUB_PATH_ANY = "/**";
    protected static final String PUBLIC_API_PATH = AbstractSecurityConfigurerAdapter.createApiPath("/public/**");
    protected final ConfigurationService configurationService;
    protected final CustomPreAuthenticatedAuthenticationProvider preAuthenticatedAuthenticationProvider;
    protected final SessionService sessionService;
    protected final AuthCookieService authCookieService;

    public AbstractSecurityConfigurerAdapter(ConfigurationService configurationService, CustomPreAuthenticatedAuthenticationProvider preAuthenticatedAuthenticationProvider, SessionService sessionService, AuthCookieService authCookieService) {
        this.configurationService = configurationService;
        this.preAuthenticatedAuthenticationProvider = preAuthenticatedAuthenticationProvider;
        this.sessionService = sessionService;
        this.authCookieService = authCookieService;
    }

    protected SecurityFilterChain applyPublicApiOptions(HttpSecurity http) {
        try {
            return (SecurityFilterChain)this.configureGenericSecurityOptions(http).authorizeHttpRequests(httpRequests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)httpRequests.anyRequest()).authenticated()).oauth2ResourceServer(oauth2resourceServer -> oauth2resourceServer.jwt(jwtConfigurer -> jwtConfigurer.decoder(this.publicApiJwtDecoder()))).build();
        }
        catch (Exception e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    protected HttpSecurity configureGenericSecurityOptions(HttpSecurity http) {
        try {
            return http.csrf(AbstractHttpConfigurer::disable).httpBasic(AbstractHttpConfigurer::disable).headers(headers -> headers.frameOptions(HeadersConfigurer.FrameOptionsConfig::disable)).sessionManagement(sessionMgmt -> sessionMgmt.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
        }
        catch (Exception e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    protected abstract JwtDecoder publicApiJwtDecoder();

    protected static String createApiPath(String ... subPath) {
        return "/api" + String.join((CharSequence)"", subPath);
    }
}

