/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.providers;

import io.camunda.optimize.dto.optimize.rest.AlertEmailValidationResponseDto;
import io.camunda.optimize.dto.optimize.rest.ConflictResponseDto;
import io.camunda.optimize.dto.optimize.rest.DefinitionExceptionResponseDto;
import io.camunda.optimize.dto.optimize.rest.ErrorResponseDto;
import io.camunda.optimize.dto.optimize.rest.ImportedIndexMismatchResponseDto;
import io.camunda.optimize.service.LocalizationService;
import io.camunda.optimize.service.exceptions.OptimizeAlertEmailValidationException;
import io.camunda.optimize.service.exceptions.OptimizeImportDefinitionDoesNotExistException;
import io.camunda.optimize.service.exceptions.OptimizeImportDescriptionNotValidException;
import io.camunda.optimize.service.exceptions.OptimizeImportForbiddenException;
import io.camunda.optimize.service.exceptions.OptimizeImportIncorrectIndexVersionException;
import io.camunda.optimize.service.exceptions.OptimizeUserOrGroupIdNotFoundException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeConflictException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
@Order(value=-2147483648)
public class OptimizeExceptionMapper {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizeExceptionMapper.class);
    @Autowired
    private LocalizationService localizationService;

    @ExceptionHandler(value={OptimizeImportDescriptionNotValidException.class})
    public ResponseEntity<ErrorResponseDto> handleReportEvaluationException(OptimizeImportDescriptionNotValidException exception) {
        LOG.info("Mapping OptimizeImportDescriptionNotValidException");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)this.getDescriptionNotValidResponseDto(exception));
    }

    private ErrorResponseDto getDescriptionNotValidResponseDto(OptimizeImportDescriptionNotValidException exception) {
        String errorCode = exception.getErrorCode();
        String errorMessage = this.localizationService.getDefaultLocaleMessageForApiErrorCode(errorCode);
        String detailedErrorMessage = exception.getMessage();
        return new ErrorResponseDto(errorCode, errorMessage, detailedErrorMessage);
    }

    @ExceptionHandler(value={OptimizeImportDefinitionDoesNotExistException.class})
    public ResponseEntity<DefinitionExceptionResponseDto> handleDefinitionDoesNotExsistException(OptimizeImportDefinitionDoesNotExistException exception) {
        LOG.info("Mapping OptimizeImportDefinitionDoesNotExistException");
        DefinitionExceptionResponseDto errorResponseDto = this.getMissingDefinitionResponseDto(exception);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)errorResponseDto);
    }

    private DefinitionExceptionResponseDto getMissingDefinitionResponseDto(OptimizeImportDefinitionDoesNotExistException exception) {
        String errorCode = exception.getErrorCode();
        String errorMessage = this.localizationService.getDefaultLocaleMessageForApiErrorCode(errorCode);
        String detailedErrorMessage = exception.getMessage();
        return new DefinitionExceptionResponseDto(errorCode, errorMessage, detailedErrorMessage, exception.getMissingDefinitions());
    }

    @ExceptionHandler(value={OptimizeConflictException.class})
    public ResponseEntity<ConflictResponseDto> handleOptimizeConflictException(OptimizeConflictException conflictException) {
        LOG.info("Mapping OptimizeConflictException");
        ConflictResponseDto errorResponseDto = this.getConflictResponseDto(conflictException);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).contentType(MediaType.APPLICATION_JSON).body((Object)errorResponseDto);
    }

    private ConflictResponseDto getConflictResponseDto(OptimizeConflictException conflictException) {
        String errorCode = conflictException.getErrorCode();
        String errorMessage = this.localizationService.getDefaultLocaleMessageForApiErrorCode(errorCode);
        String detailedErrorMessage = conflictException.getMessage();
        return new ConflictResponseDto(errorCode, errorMessage, detailedErrorMessage, conflictException.getConflictedItems());
    }

    @ExceptionHandler(value={OptimizeAlertEmailValidationException.class})
    public ResponseEntity<AlertEmailValidationResponseDto> handleOptimizeAlertEmailValidationException(OptimizeAlertEmailValidationException optimizeAlertEmailValidationException) {
        LOG.info("Mapping OptimizeAlertEmailValidationException");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)new AlertEmailValidationResponseDto(optimizeAlertEmailValidationException));
    }

    @ExceptionHandler(value={OptimizeImportForbiddenException.class})
    public ResponseEntity<DefinitionExceptionResponseDto> toResponse(OptimizeImportForbiddenException exception) {
        LOG.info("Mapping OptimizeImportForbiddenException");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).contentType(MediaType.APPLICATION_JSON).body((Object)this.getForbiddenDefinitionResponseDto(exception));
    }

    private DefinitionExceptionResponseDto getForbiddenDefinitionResponseDto(OptimizeImportForbiddenException exception) {
        String errorCode = exception.getErrorCode();
        String errorMessage = this.localizationService.getDefaultLocaleMessageForApiErrorCode(errorCode);
        String detailedErrorMessage = exception.getMessage();
        return new DefinitionExceptionResponseDto(errorCode, errorMessage, detailedErrorMessage, exception.getForbiddenDefinitions());
    }

    @ExceptionHandler(value={OptimizeImportIncorrectIndexVersionException.class})
    public ResponseEntity<ImportedIndexMismatchResponseDto> toResponse(OptimizeImportIncorrectIndexVersionException exception) {
        LOG.info("Mapping OptimizeImportIncorrectIndexVersionException");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)this.getIndexMismatchResponseDto(exception));
    }

    private ImportedIndexMismatchResponseDto getIndexMismatchResponseDto(OptimizeImportIncorrectIndexVersionException exception) {
        String errorCode = exception.getErrorCode();
        String errorMessage = this.localizationService.getDefaultLocaleMessageForApiErrorCode(errorCode);
        String detailedErrorMessage = exception.getMessage();
        return new ImportedIndexMismatchResponseDto(errorCode, errorMessage, detailedErrorMessage, exception.getMismatchingIndices());
    }

    @ExceptionHandler(value={OptimizeUserOrGroupIdNotFoundException.class})
    public ResponseEntity<ErrorResponseDto> toResponse(OptimizeUserOrGroupIdNotFoundException idNotFoundException) {
        LOG.info("Mapping OptimizeUserOrGroupIdNotFoundException");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)this.getErrorResponseDto(idNotFoundException));
    }

    private ErrorResponseDto getErrorResponseDto(OptimizeUserOrGroupIdNotFoundException exception) {
        String errorCode = exception.getErrorCode();
        String errorMessage = this.localizationService.getDefaultLocaleMessageForApiErrorCode(errorCode);
        String detailedErrorMessage = exception.getMessage();
        return new ErrorResponseDto(errorCode, errorMessage, detailedErrorMessage);
    }
}

