/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.mapper;

import io.camunda.optimize.dto.optimize.RoleType;
import io.camunda.optimize.dto.optimize.query.report.AuthorizedReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.CombinedReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.ReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.SingleReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizedReportDefinitionResponseDto;
import io.camunda.optimize.dto.optimize.rest.report.AuthorizedCombinedReportEvaluationResponseDto;
import io.camunda.optimize.dto.optimize.rest.report.AuthorizedProcessReportEvaluationResponseDto;
import io.camunda.optimize.dto.optimize.rest.report.AuthorizedReportEvaluationResponseDto;
import io.camunda.optimize.dto.optimize.rest.report.AuthorizedSingleReportEvaluationResponseDto;
import io.camunda.optimize.dto.optimize.rest.report.CombinedProcessReportResultDataDto;
import io.camunda.optimize.dto.optimize.rest.report.ReportResultResponseDto;
import io.camunda.optimize.dto.optimize.rest.report.measure.MeasureResponseDto;
import io.camunda.optimize.service.LocalizationService;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReportRestMapper {
    private static final Logger LOG = LoggerFactory.getLogger(ReportRestMapper.class);
    private final AbstractIdentityService identityService;
    private final LocalizationService localizationService;

    public ReportRestMapper(AbstractIdentityService identityService, LocalizationService localizationService) {
        this.identityService = identityService;
        this.localizationService = localizationService;
    }

    public <T> AuthorizedReportEvaluationResponseDto<?> mapToLocalizedEvaluationResponseDto(AuthorizedReportEvaluationResult reportEvaluationResult, String locale) {
        return this.mapToLocalizedEvaluationResponseDto(reportEvaluationResult, locale, false);
    }

    public <T> AuthorizedReportEvaluationResponseDto<?> mapToLocalizedEvaluationResponseDto(AuthorizedReportEvaluationResult reportEvaluationResult, String locale, boolean skipNameResolution) {
        ReportEvaluationResult reportEvaluationResult2;
        if (!skipNameResolution) {
            this.resolveOwnerAndModifierNames(reportEvaluationResult.getEvaluationResult().getReportDefinition());
        }
        if ((reportEvaluationResult2 = reportEvaluationResult.getEvaluationResult()) instanceof CombinedReportEvaluationResult) {
            CombinedReportEvaluationResult combinedReportEvaluationResult = (CombinedReportEvaluationResult)reportEvaluationResult2;
            Map reportResults = combinedReportEvaluationResult.getReportEvaluationResults().stream().map(this::mapToAuthorizedProcessReportEvaluationResponseDto).map(response -> response).collect(Collectors.toMap(singleReportEvaluationResponse -> ((SingleProcessReportDefinitionRequestDto)singleReportEvaluationResponse.getReportDefinition()).getId(), Function.identity(), (x, y) -> y, LinkedHashMap::new));
            return new AuthorizedCombinedReportEvaluationResponseDto(reportEvaluationResult.getCurrentUserRole(), (CombinedReportDefinitionRequestDto)reportEvaluationResult.getEvaluationResult().getReportDefinition(), new CombinedProcessReportResultDataDto(reportResults, combinedReportEvaluationResult.getInstanceCount()));
        }
        SingleReportEvaluationResult singleReportEvaluationResult = (SingleReportEvaluationResult)reportEvaluationResult.getEvaluationResult();
        return this.mapToLocalizedEvaluationResponseDto(reportEvaluationResult.getCurrentUserRole(), singleReportEvaluationResult, locale);
    }

    public void prepareLocalizedRestResponse(AuthorizedReportDefinitionResponseDto authorizedReportDefinitionDto, String locale) {
        this.resolveOwnerAndModifierNames(authorizedReportDefinitionDto.getDefinitionDto());
        this.localizeReportData(authorizedReportDefinitionDto.getDefinitionDto(), locale);
    }

    public static void localizeReportData(ReportDefinitionDto<?> reportDefinitionDto, String locale, LocalizationService localizationService) {
        if (ReportRestMapper.isManagementOrInstantPreviewReport(reportDefinitionDto)) {
            String validLocale = localizationService.validateAndReturnValidLocale(locale);
            if (((ProcessReportDataDto)((SingleProcessReportDefinitionRequestDto)reportDefinitionDto).getData()).isManagementReport()) {
                Optional.ofNullable(localizationService.getLocalizationForManagementReportCode(validLocale, reportDefinitionDto.getName())).ifPresent(arg_0 -> reportDefinitionDto.setName(arg_0));
                Optional.ofNullable(localizationService.getLocalizationForManagementReportCode(validLocale, reportDefinitionDto.getDescription())).ifPresent(arg_0 -> reportDefinitionDto.setDescription(arg_0));
            } else {
                Optional.ofNullable(localizationService.getLocalizationForInstantPreviewReportCode(validLocale, reportDefinitionDto.getName())).ifPresent(arg_0 -> reportDefinitionDto.setName(arg_0));
                Optional.ofNullable(localizationService.getLocalizationForInstantPreviewReportCode(validLocale, reportDefinitionDto.getDescription())).ifPresent(arg_0 -> reportDefinitionDto.setDescription(arg_0));
            }
            ReportRestMapper.localizeChartLabels(reportDefinitionDto, localizationService, validLocale);
        }
    }

    private static void localizeChartLabels(ReportDefinitionDto<?> reportDefinitionDto, LocalizationService localizationService, String validLocale) {
        SingleReportDataDto reportDataDto;
        ReportDataDto reportDataDto2 = reportDefinitionDto.getData();
        if (reportDataDto2 instanceof SingleReportDataDto && (reportDataDto = (SingleReportDataDto)reportDataDto2).getConfiguration() != null) {
            Optional.ofNullable(reportDataDto.getConfiguration().getXLabel()).map(xLabel -> localizationService.getLocalizedXLabel(validLocale, (String)xLabel)).ifPresent(localizedLabel -> ((SingleReportDataDto)reportDefinitionDto.getData()).getConfiguration().setXLabel(localizedLabel));
            if (reportDataDto instanceof ProcessReportDataDto) {
                ProcessReportDataDto processReportData = (ProcessReportDataDto)reportDataDto;
                Optional.ofNullable(processReportData.getConfiguration().getYLabel()).map(yLabel -> localizationService.getLocalizedYLabel(validLocale, (String)yLabel, processReportData.getView().getFirstProperty())).ifPresent(localizedLabel -> ((SingleReportDataDto)reportDefinitionDto.getData()).getConfiguration().setYLabel(localizedLabel));
            }
        }
    }

    private <T> AuthorizedProcessReportEvaluationResponseDto<T> mapToAuthorizedProcessReportEvaluationResponseDto(SingleReportEvaluationResult<T> singleReportEvaluationResult) {
        return new AuthorizedProcessReportEvaluationResponseDto<T>(null, this.mapToReportResultResponseDto(singleReportEvaluationResult), (SingleProcessReportDefinitionRequestDto)singleReportEvaluationResult.getReportDefinition());
    }

    private <T, R extends ReportDefinitionDto<?>> AuthorizedSingleReportEvaluationResponseDto<T, R> mapToLocalizedEvaluationResponseDto(RoleType currentUserRole, SingleReportEvaluationResult<?> evaluationResult, String locale) {
        AuthorizedSingleReportEvaluationResponseDto mappedResult = new AuthorizedSingleReportEvaluationResponseDto(currentUserRole, this.mapToReportResultResponseDto(evaluationResult), evaluationResult.getReportDefinition());
        this.localizeReportData((ReportDefinitionDto<?>)mappedResult.getReportDefinition(), locale);
        return mappedResult;
    }

    private <T> ReportResultResponseDto<T> mapToReportResultResponseDto(SingleReportEvaluationResult<T> evaluationResult) {
        CommandEvaluationResult<T> firstCommandResult = evaluationResult.getFirstCommandResult();
        return new ReportResultResponseDto(firstCommandResult.getInstanceCount(), firstCommandResult.getInstanceCountWithoutFilters(), evaluationResult.getCommandEvaluationResults().stream().flatMap(commandResult -> commandResult.getMeasures().stream().map(measureDto -> new MeasureResponseDto<Object>(measureDto.getProperty(), measureDto.getAggregationType(), measureDto.getUserTaskDurationTime(), measureDto.getData(), commandResult.getType()))).collect(Collectors.toList()), firstCommandResult.getPagination().isValid() ? firstCommandResult.getPagination() : null);
    }

    private void resolveOwnerAndModifierNames(ReportDefinitionDto<?> reportDefinitionDto) {
        Optional.ofNullable(reportDefinitionDto.getOwner()).flatMap(this.identityService::getIdentityNameById).ifPresent(arg_0 -> reportDefinitionDto.setOwner(arg_0));
        Optional.ofNullable(reportDefinitionDto.getLastModifier()).flatMap(this.identityService::getIdentityNameById).ifPresent(arg_0 -> reportDefinitionDto.setLastModifier(arg_0));
    }

    private static boolean isManagementOrInstantPreviewReport(ReportDefinitionDto<?> reportDefinitionDto) {
        return reportDefinitionDto instanceof SingleProcessReportDefinitionRequestDto && (((ProcessReportDataDto)((SingleProcessReportDefinitionRequestDto)reportDefinitionDto).getData()).isManagementReport() || ((ProcessReportDataDto)((SingleProcessReportDefinitionRequestDto)reportDefinitionDto).getData()).isInstantPreviewReport());
    }

    private void localizeReportData(ReportDefinitionDto<?> reportDefinitionDto, String locale) {
        ReportRestMapper.localizeReportData(reportDefinitionDto, locale, this.localizationService);
    }
}

