/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.cloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.rest.cloud.AbstractCCSaaSClient;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSaaSCondition.class})
public class CCSaaSOrganizationsClient
extends AbstractCCSaaSClient {
    private static final Logger LOG = LoggerFactory.getLogger(CCSaaSOrganizationsClient.class);

    public CCSaaSOrganizationsClient(ConfigurationService configurationService, ObjectMapper objectMapper) {
        super(objectMapper, configurationService);
    }

    public Optional<String> getSalesPlanType(String accessToken) {
        Optional<String> optional;
        block9: {
            LOG.info("Fetching cloud organisation.");
            HttpGet request = new HttpGet(String.format("%s/external/organizations/%s", this.getCloudUsersConfiguration().getAccountsUrl(), this.getCloudAuthConfiguration().getOrganizationId()));
            CloseableHttpResponse response = this.performRequest((HttpRequestBase)request, accessToken);
            try {
                if (response.getStatusLine().getStatusCode() != HttpStatus.OK.value()) {
                    throw new OptimizeRuntimeException(String.format("Unexpected response when fetching cloud organisation: %s", response.getStatusLine().getStatusCode()));
                }
                AccountsOrganisationResponse responseEntity = (AccountsOrganisationResponse)this.objectMapper.readValue(response.getEntity().getContent(), AccountsOrganisationResponse.class);
                optional = Optional.ofNullable(responseEntity).flatMap(AccountsOrganisationResponse::getSalesPlan).flatMap(AccountsSalesPlanDto::getType);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OptimizeRuntimeException("There was a problem fetching the cloud organisation.", (Throwable)e);
                }
            }
            response.close();
        }
        return optional;
    }

    public static class AccountsOrganisationResponse {
        private Optional<AccountsSalesPlanDto> salesPlan;

        public AccountsOrganisationResponse(Optional<AccountsSalesPlanDto> salesPlan) {
            this.salesPlan = salesPlan;
        }

        protected AccountsOrganisationResponse() {
        }

        public Optional<AccountsSalesPlanDto> getSalesPlan() {
            return this.salesPlan;
        }

        public void setSalesPlan(Optional<AccountsSalesPlanDto> salesPlan) {
            this.salesPlan = salesPlan;
        }

        protected boolean canEqual(Object other) {
            return other instanceof AccountsOrganisationResponse;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
        }

        public String toString() {
            return "CCSaaSOrganizationsClient.AccountsOrganisationResponse(salesPlan=" + String.valueOf(this.getSalesPlan()) + ")";
        }
    }

    public static class AccountsSalesPlanDto {
        private Optional<String> type;

        public AccountsSalesPlanDto(Optional<String> type) {
            this.type = type;
        }

        protected AccountsSalesPlanDto() {
        }

        public Optional<String> getType() {
            return this.type;
        }

        public void setType(Optional<String> type) {
            this.type = type;
        }

        protected boolean canEqual(Object other) {
            return other instanceof AccountsSalesPlanDto;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
        }

        public String toString() {
            return "CCSaaSOrganizationsClient.AccountsSalesPlanDto(type=" + String.valueOf(this.getType()) + ")";
        }
    }
}

