/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.cloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.optimize.dto.optimize.cloud.TokenResponseDto;
import io.camunda.optimize.dto.optimize.cloud.panelnotifications.PanelNotificationRequestDto;
import io.camunda.optimize.rest.cloud.AbstractCCSaaSClient;
import io.camunda.optimize.rest.cloud.CCSaaSM2MTokenProvider;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSaaSCondition.class})
public class CCSaaSNotificationClient
extends AbstractCCSaaSClient {
    private static final Logger LOG = LoggerFactory.getLogger(CCSaaSNotificationClient.class);
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="False positives")
    private TokenResponseDto accessToken;
    private Instant tokenExpires = Instant.now();
    private final CCSaaSM2MTokenProvider m2mTokenProvider;

    public CCSaaSNotificationClient(ObjectMapper objectMapper, ConfigurationService configurationService, CCSaaSM2MTokenProvider m2mTokenProvider) {
        super(objectMapper, configurationService);
        this.m2mTokenProvider = m2mTokenProvider;
    }

    public void sendPanelNotificationToOrg(PanelNotificationRequestDto notificationRequestDto) {
        LOG.info("Sending org notification [{}].", (Object)notificationRequestDto.getNotification().getUniqueId());
        try {
            HttpPost request = new HttpPost(this.getSaaSNotificationApiUrl() + "/notifications/org");
            StringEntity notificationRequestBody = new StringEntity(this.objectMapper.writeValueAsString((Object)notificationRequestDto), ContentType.APPLICATION_JSON);
            request.setHeader("Content-Type", "application/json");
            request.setEntity((HttpEntity)notificationRequestBody);
            try (CloseableHttpResponse response = this.performNotificationRequest(request);){
                HttpStatus status = HttpStatus.resolve((int)response.getStatusLine().getStatusCode());
                if (!HttpStatus.OK.equals((Object)status)) {
                    throw new OptimizeRuntimeException("Unexpected response when sending notification: " + String.valueOf(status));
                }
            }
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("There was a problem sending the notification.", (Throwable)e);
        }
    }

    public synchronized void refreshAccessTokenIfRequired() {
        if (Instant.now().plus(15L, ChronoUnit.MINUTES).isAfter(this.tokenExpires)) {
            this.accessToken = this.m2mTokenProvider.retrieveM2MToken(this.configurationService.getPanelNotificationConfiguration().getM2mTokenAudience());
            this.tokenExpires = Instant.now().plusSeconds(this.accessToken.getExpiresIn());
        }
    }

    private CloseableHttpResponse performNotificationRequest(HttpPost notificationRequest) throws IOException {
        this.refreshAccessTokenIfRequired();
        return this.performRequest((HttpRequestBase)notificationRequest, this.accessToken.getAccessToken());
    }

    private String getSaaSNotificationApiUrl() {
        return this.configurationService.getPanelNotificationConfiguration().getUrl();
    }
}

