/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.query.processoverview.InitialProcessOwnerDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessOverviewResponseDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessUpdateDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.dto.optimize.rest.sorting.ProcessOverviewSorter;
import io.camunda.optimize.rest.exceptions.NotAuthorizedException;
import io.camunda.optimize.service.ProcessOverviewService;
import io.camunda.optimize.service.security.SessionService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/process"})
public class ProcessOverviewRestService {
    public static final String PROCESS_PATH = "/process";
    private final ProcessOverviewService processOverviewService;
    private final SessionService sessionService;

    public ProcessOverviewRestService(ProcessOverviewService processOverviewService, SessionService sessionService) {
        this.processOverviewService = processOverviewService;
        this.sessionService = sessionService;
    }

    @GetMapping(value={"/overview"})
    public List<ProcessOverviewResponseDto> getProcessOverviews(@RequestParam(name="sortBy", required=false) String sortBy, @RequestParam(name="sortOrder", required=false) SortOrder sortOrder, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        List<ProcessOverviewResponseDto> processOverviewResponseDtos = this.processOverviewService.getAllProcessOverviews(userId, request.getHeader("X-Optimize-Client-Locale"));
        ProcessOverviewSorter processOverviewSorter = new ProcessOverviewSorter(sortBy, sortOrder);
        return processOverviewSorter.applySort(processOverviewResponseDtos);
    }

    @PutMapping(path={"/{processDefinitionKey}"})
    public void updateProcess(@PathVariable(value="processDefinitionKey") String processDefKey, @NotNull @Valid @RequestBody ProcessUpdateDto processUpdateDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.processOverviewService.updateProcess(userId, processDefKey, processUpdateDto);
    }

    @PostMapping(path={"/initial-owner"})
    public void setInitialProcessOwner(@NotNull @Valid @RequestBody InitialProcessOwnerDto ownerDto, HttpServletRequest request) {
        Optional<String> userId;
        try {
            userId = Optional.ofNullable(this.sessionService.getRequestUserOrFailNotAuthorized(request));
        }
        catch (NotAuthorizedException e) {
            userId = Optional.ofNullable(request.getUserPrincipal().getName());
        }
        userId.ifPresentOrElse(id -> this.processOverviewService.updateProcessOwnerIfNotSet((String)id, ownerDto.getProcessDefinitionKey(), ownerDto.getOwner()), () -> {
            throw new NotAuthorizedException("Could not resolve user for this request");
        });
    }
}

