/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.rest.providers.CacheRequest;
import io.camunda.optimize.service.LocalizationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/localization"})
public class LocalizationRestService {
    public static final String LOCALIZATION_PATH = "/localization";
    private static final Logger LOG = LoggerFactory.getLogger(LocalizationRestService.class);
    private final LocalizationService localizationService;

    public LocalizationRestService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    @GetMapping(produces={"application/json"})
    @CacheRequest
    public byte[] getLocalizationFile(@RequestParam(name="localeCode", required=false) String localeCode) {
        return this.localizationService.getLocalizationFileBytes(localeCode);
    }
}

