/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.query.EntityIdResponseDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizationType;
import io.camunda.optimize.dto.optimize.rest.export.OptimizeEntityExportDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.service.entities.EntityImportService;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.security.SessionService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Set;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/import"})
public class ImportRestService {
    public static final String IMPORT_PATH = "/import";
    private final SessionService sessionService;
    private final EntityImportService entityImportService;
    private final AbstractIdentityService identityService;

    public ImportRestService(SessionService sessionService, EntityImportService entityImportService, AbstractIdentityService identityService) {
        this.sessionService = sessionService;
        this.entityImportService = entityImportService;
        this.identityService = identityService;
    }

    @PostMapping
    public List<EntityIdResponseDto> importEntities(@RequestParam(name="collectionId", required=false) String collectionId, @RequestBody String exportedDtoJson, HttpServletRequest request) {
        Set<OptimizeEntityExportDto> exportDtos = this.entityImportService.readExportDtoOrFailIfInvalid(exportedDtoJson);
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.validateUserAuthorization(collectionId);
        return this.entityImportService.importEntitiesAsUser(userId, collectionId, exportDtos);
    }

    private void validateUserAuthorization(String collectionId) {
        if (collectionId == null && !this.identityService.getEnabledAuthorizations().contains((Object)AuthorizationType.ENTITY_EDITOR)) {
            throw new ForbiddenException("User not authorized to create reports outside of a collection");
        }
    }
}

