/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.license;

import io.camunda.optimize.license.LicenseType;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.camunda.bpm.licensecheck.InvalidLicenseException;
import org.camunda.bpm.licensecheck.LicenseKey;
import org.camunda.bpm.licensecheck.LicenseKeyImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamundaLicense {
    public static final String CAMUNDA_LICENSE_ENV_VAR_KEY = "CAMUNDA_LICENSE_KEY";
    private static final Logger LOGGER = LoggerFactory.getLogger(CamundaLicense.class);
    private boolean isValid;
    private LicenseType licenseType;
    private boolean isCommercial;
    private OffsetDateTime expiresAt;
    private boolean isInitialized;

    public CamundaLicense(String license) {
        this.initializeWithLicense(license);
    }

    public synchronized boolean isValid() {
        return this.isValid;
    }

    public synchronized LicenseType getLicenseType() {
        return this.licenseType;
    }

    public synchronized boolean isCommercial() {
        return this.isCommercial;
    }

    public synchronized OffsetDateTime expiresAt() {
        return this.expiresAt;
    }

    public synchronized void initializeWithLicense(String license) {
        if (this.isInitialized) {
            return;
        }
        if (license != null && !license.isBlank()) {
            this.validateLicense(license);
        } else {
            this.isValid = false;
            this.licenseType = LicenseType.UNKNOWN;
            LOGGER.warn("No license detected when one is expected. Please provide a license through the CAMUNDA_LICENSE_KEY environment variable.");
        }
        this.isInitialized = true;
    }

    private void validateLicense(String licenseStr) {
        try {
            LicenseKey licenseKey = this.getLicenseKey(licenseStr);
            this.isCommercial = licenseKey.isCommercial();
            if (licenseKey.getValidUntil() != null) {
                this.expiresAt = licenseKey.getValidUntil().toInstant().atOffset(ZoneOffset.UTC);
            }
            licenseKey.validate();
            this.licenseType = LicenseType.get((String)licenseKey.getProperties().get("licenseType"));
            if (LicenseType.UNKNOWN.equals((Object)this.licenseType)) {
                LOGGER.warn("Expected a valid licenseType property on the Camunda License, but none were found.");
                this.isValid = false;
            } else {
                this.isValid = true;
            }
            return;
        }
        catch (InvalidLicenseException e) {
            LOGGER.warn("Expected a valid license when determining license validity, but encountered an invalid one instead. ", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.warn("Expected to determine the validity of the license, but the following unexpected error was encountered: ", (Throwable)e);
        }
        this.licenseType = LicenseType.UNKNOWN;
        this.isValid = false;
    }

    protected LicenseKey getLicenseKey(String licenseStr) throws InvalidLicenseException {
        return new LicenseKeyImpl(licenseStr);
    }
}

