/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.dto.optimize.query.report;

import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.ReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.SingleReportDefinitionDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginatedDataExportDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationScrollableDto;
import io.camunda.optimize.service.db.report.result.RawDataCommandResult;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SingleReportEvaluationResult<T>
extends ReportEvaluationResult {
    private List<CommandEvaluationResult<T>> commandEvaluationResults;

    public SingleReportEvaluationResult(SingleReportDefinitionDto<?> reportDefinition, CommandEvaluationResult<T> commandEvaluationResult) {
        super(reportDefinition);
        if (reportDefinition == null) {
            throw new IllegalArgumentException("reportDefinition cannot be null");
        }
        if (commandEvaluationResult == null) {
            throw new IllegalArgumentException("commandEvaluationResult cannot be null");
        }
        this.commandEvaluationResults = Collections.singletonList(commandEvaluationResult);
    }

    public SingleReportEvaluationResult(ReportDefinitionDto<?> reportDefinition, List<CommandEvaluationResult<T>> commandEvaluationResults) {
        super(reportDefinition);
        if (reportDefinition == null) {
            throw new IllegalArgumentException("reportDefinition cannot be null");
        }
        if (commandEvaluationResults == null) {
            throw new IllegalArgumentException("commandEvaluationResult cannot be null");
        }
        this.commandEvaluationResults = commandEvaluationResults;
    }

    public CommandEvaluationResult<T> getFirstCommandResult() {
        return this.commandEvaluationResults.stream().findFirst().orElse(null);
    }

    public List<String[]> getResultAsCsv(Integer limit, Integer offset, ZoneId timezone) {
        return this.commandEvaluationResults.get(0).getResultAsCsv(limit, offset, timezone);
    }

    public PaginatedDataExportDto getResult() {
        CommandEvaluationResult<T> commandResult = this.getFirstCommandResult();
        PaginatedDataExportDto result = new PaginatedDataExportDto();
        result.setData(commandResult.getResult());
        if (commandResult instanceof RawDataCommandResult) {
            result.setTotalNumberOfRecords(commandResult.getInstanceCount());
            if (commandResult.getPagination() instanceof PaginationScrollableDto) {
                result.setSearchRequestId(((PaginationScrollableDto)commandResult.getPagination()).getScrollId());
            } else {
                result.setSearchRequestId(null);
            }
        } else {
            ArrayList data = Optional.ofNullable(result.getData()).orElse(new ArrayList());
            int payloadSize = data instanceof List ? ((List)data).size() : 1;
            result.setTotalNumberOfRecords((long)payloadSize);
        }
        return result;
    }

    protected boolean canEqual(Object other) {
        return other instanceof SingleReportEvaluationResult;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)((Object)this), (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return "SingleReportEvaluationResult(commandEvaluationResults=" + String.valueOf(this.getCommandEvaluationResults()) + ")";
    }

    public List<CommandEvaluationResult<T>> getCommandEvaluationResults() {
        return this.commandEvaluationResults;
    }

    public void setCommandEvaluationResults(List<CommandEvaluationResult<T>> commandEvaluationResults) {
        if (commandEvaluationResults == null) {
            throw new IllegalArgumentException("commandEvaluationResults cannot be null");
        }
        this.commandEvaluationResults = commandEvaluationResults;
    }
}

