/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.dto.optimize.query.analysis;

import io.camunda.optimize.dto.optimize.ReportConstants;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.rest.queryparam.QueryParamUtil;
import io.camunda.optimize.service.util.TenantListHandlingUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ProcessDefinitionParametersDto {
    protected String processDefinitionKey;
    protected List<String> processDefinitionVersions;
    protected List<String> tenantIds = ReportConstants.DEFAULT_TENANT_IDS;
    protected Long minimumDeviationFromAvg = 50L;
    protected Boolean disconsiderAutomatedTasks = false;
    protected List<ProcessFilterDto<?>> filters = new ArrayList();

    protected List<String> normalizeNullTenants(List<String> tenantIds) {
        return tenantIds.stream().map(QueryParamUtil::normalizeNullStringValue).collect(Collectors.toList());
    }

    private List<String> normalizeTenants(List<String> tenantIds) {
        List<String> normalizedTenantIds = this.normalizeNullTenants(tenantIds);
        return normalizedTenantIds.isEmpty() ? ReportConstants.DEFAULT_TENANT_IDS : normalizedTenantIds;
    }

    public List<String> getTenantIds() {
        return TenantListHandlingUtil.sortAndReturnTenantIdList(this.tenantIds);
    }

    public void setTenantIds(List<String> tenantIds) {
        this.tenantIds = this.normalizeTenants(tenantIds);
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public List<String> getProcessDefinitionVersions() {
        return this.processDefinitionVersions;
    }

    public void setProcessDefinitionVersions(List<String> processDefinitionVersions) {
        this.processDefinitionVersions = processDefinitionVersions;
    }

    public Long getMinimumDeviationFromAvg() {
        return this.minimumDeviationFromAvg;
    }

    public void setMinimumDeviationFromAvg(Long minimumDeviationFromAvg) {
        this.minimumDeviationFromAvg = minimumDeviationFromAvg;
    }

    public Boolean getDisconsiderAutomatedTasks() {
        return this.disconsiderAutomatedTasks;
    }

    public void setDisconsiderAutomatedTasks(Boolean disconsiderAutomatedTasks) {
        this.disconsiderAutomatedTasks = disconsiderAutomatedTasks;
    }

    public List<ProcessFilterDto<?>> getFilters() {
        return this.filters;
    }

    public void setFilters(List<ProcessFilterDto<?>> filters) {
        this.filters = filters;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessDefinitionParametersDto;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return "ProcessDefinitionParametersDto(processDefinitionKey=" + this.getProcessDefinitionKey() + ", processDefinitionVersions=" + String.valueOf(this.getProcessDefinitionVersions()) + ", tenantIds=" + String.valueOf(this.getTenantIds()) + ", minimumDeviationFromAvg=" + this.getMinimumDeviationFromAvg() + ", disconsiderAutomatedTasks=" + this.getDisconsiderAutomatedTasks() + ", filters=" + String.valueOf(this.getFilters()) + ")";
    }
}

