/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.dto.optimize.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class PageResultDto<T> {
    private String pagingState;
    private int limit;
    private List<T> entities = new ArrayList<T>();

    public PageResultDto(int limit) {
        this.limit = limit;
    }

    public PageResultDto(String pagingState, int limit, List<T> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("entities cannot be null");
        }
        this.pagingState = pagingState;
        this.limit = limit;
        this.entities = entities;
    }

    protected PageResultDto() {
    }

    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    public boolean isLastPage() {
        return this.pagingState == null;
    }

    public String getPagingState() {
        return this.pagingState;
    }

    public void setPagingState(String pagingState) {
        this.pagingState = pagingState;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public List<T> getEntities() {
        return this.entities;
    }

    public void setEntities(List<T> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("entities cannot be null");
        }
        this.entities = entities;
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResultDto;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return "PageResultDto(pagingState=" + this.getPagingState() + ", limit=" + this.getLimit() + ", entities=" + String.valueOf(this.getEntities()) + ")";
    }
}

