/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.util.decision;

import io.camunda.optimize.dto.optimize.query.report.single.ReportDataDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionVisualization;
import io.camunda.optimize.dto.optimize.query.report.single.decision.filter.DecisionFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.group.DecisionGroupByDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.group.DecisionGroupByMatchedRuleDto;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.report.interpreter.util.DecisionGroupByDtoCreator;
import io.camunda.optimize.service.db.report.interpreter.util.DecisionViewDtoCreator;
import io.camunda.optimize.test.util.decision.DecisionReportDataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DecisionReportDataBuilder {
    private DecisionReportDataType reportDataType;
    private List<ReportDataDefinitionDto> definitions = Collections.singletonList(new ReportDataDefinitionDto());
    private String variableId;
    private String variableName;
    private VariableType variableType;
    private AggregateByDateUnit dateInterval;
    private List<DecisionFilterDto<?>> filter = new ArrayList();

    public static DecisionReportDataBuilder create() {
        return new DecisionReportDataBuilder();
    }

    public DecisionReportDataDto build() {
        DecisionReportDataDto reportData = switch (this.reportDataType) {
            case DecisionReportDataType.RAW_DATA -> DecisionReportDataBuilder.createDecisionReportDataViewRawAsTable(this.definitions);
            case DecisionReportDataType.COUNT_DEC_INST_FREQ_GROUP_BY_NONE -> DecisionReportDataBuilder.createCountFrequencyReportGroupByNone(this.definitions);
            case DecisionReportDataType.COUNT_DEC_INST_FREQ_GROUP_BY_EVALUATION_DATE_TIME -> DecisionReportDataBuilder.createCountFrequencyReportGroupByEvaluationDate(this.definitions, this.dateInterval);
            case DecisionReportDataType.COUNT_DEC_INST_FREQ_GROUP_BY_INPUT_VARIABLE -> DecisionReportDataBuilder.createCountFrequencyReportGroupByInputVariable(this.definitions, this.variableId, this.variableName, this.variableType);
            case DecisionReportDataType.COUNT_DEC_INST_FREQ_GROUP_BY_OUTPUT_VARIABLE -> DecisionReportDataBuilder.createCountFrequencyReportGroupByOutputVariable(this.definitions, this.variableId, this.variableName, this.variableType);
            case DecisionReportDataType.COUNT_DEC_INST_FREQ_GROUP_BY_MATCHED_RULE -> DecisionReportDataBuilder.createCountFrequencyReportGroupByMatchedRule(this.definitions);
            default -> throw new IllegalStateException("Unsupported type: " + String.valueOf((Object)this.reportDataType));
        };
        reportData.setFilter(this.filter);
        return reportData;
    }

    public DecisionReportDataBuilder setReportDataType(DecisionReportDataType reportDataType) {
        this.reportDataType = reportDataType;
        return this;
    }

    public DecisionReportDataBuilder definitions(List<ReportDataDefinitionDto> definitions) {
        this.definitions = definitions;
        return this;
    }

    public DecisionReportDataBuilder setDecisionDefinitionKey(String decisionDefinitionKey) {
        this.definitions.get(0).setKey(decisionDefinitionKey);
        return this;
    }

    public DecisionReportDataBuilder setDecisionDefinitionVersion(String decisionDefinitionVersion) {
        this.definitions.get(0).setVersion(decisionDefinitionVersion);
        return this;
    }

    public DecisionReportDataBuilder setDecisionDefinitionVersions(List<String> decisionDefinitionVersions) {
        this.definitions.get(0).setVersions(decisionDefinitionVersions);
        return this;
    }

    public DecisionReportDataBuilder setTenantId(String tenantId) {
        return this.setTenantIds(Collections.singletonList(tenantId));
    }

    public DecisionReportDataBuilder setTenantIds(List<String> tenantIds) {
        this.definitions.get(0).setTenantIds(tenantIds);
        return this;
    }

    public DecisionReportDataBuilder setVariableId(String variableId) {
        this.variableId = variableId;
        return this;
    }

    public DecisionReportDataBuilder setVariableName(String variableName) {
        this.variableName = variableName;
        return this;
    }

    public DecisionReportDataBuilder setVariableType(VariableType variableType) {
        this.variableType = variableType;
        return this;
    }

    public DecisionReportDataBuilder setDateInterval(AggregateByDateUnit dateInterval) {
        this.dateInterval = dateInterval;
        return this;
    }

    public DecisionReportDataBuilder setFilter(DecisionFilterDto newFilter) {
        this.filter = Collections.singletonList(newFilter);
        return this;
    }

    public DecisionReportDataBuilder setFilter(List<DecisionFilterDto<?>> newFilter) {
        this.filter = newFilter;
        return this;
    }

    public static DecisionReportDataDto createDecisionReportDataViewRawAsTable(List<ReportDataDefinitionDto> definitions) {
        DecisionReportDataDto decisionReportDataDto = new DecisionReportDataDto();
        decisionReportDataDto.setDefinitions(definitions);
        decisionReportDataDto.setVisualization(DecisionVisualization.TABLE);
        decisionReportDataDto.setView(DecisionViewDtoCreator.createDecisionRawDataView());
        decisionReportDataDto.setGroupBy(DecisionGroupByDtoCreator.createGroupDecisionByNone());
        return decisionReportDataDto;
    }

    private static DecisionReportDataDto createCountFrequencyReportGroupByNone(List<ReportDataDefinitionDto> definitions) {
        DecisionReportDataDto decisionReportDataDto = new DecisionReportDataDto();
        decisionReportDataDto.setDefinitions(definitions);
        decisionReportDataDto.setVisualization(DecisionVisualization.NUMBER);
        decisionReportDataDto.setView(DecisionViewDtoCreator.createCountFrequencyView());
        decisionReportDataDto.setGroupBy(DecisionGroupByDtoCreator.createGroupDecisionByNone());
        return decisionReportDataDto;
    }

    private static DecisionReportDataDto createCountFrequencyReportGroupByEvaluationDate(List<ReportDataDefinitionDto> definitions, AggregateByDateUnit groupByDateUnit) {
        DecisionReportDataDto decisionReportDataDto = new DecisionReportDataDto();
        decisionReportDataDto.setDefinitions(definitions);
        decisionReportDataDto.setVisualization(DecisionVisualization.TABLE);
        decisionReportDataDto.setView(DecisionViewDtoCreator.createCountFrequencyView());
        decisionReportDataDto.setGroupBy(DecisionGroupByDtoCreator.createGroupDecisionByEvaluationDateTime((AggregateByDateUnit)groupByDateUnit));
        return decisionReportDataDto;
    }

    private static DecisionReportDataDto createCountFrequencyReportGroupByInputVariable(List<ReportDataDefinitionDto> definitions, String variableId, String variableName, VariableType variableType) {
        DecisionReportDataDto decisionReportDataDto = new DecisionReportDataDto();
        decisionReportDataDto.setDefinitions(definitions);
        decisionReportDataDto.setVisualization(DecisionVisualization.TABLE);
        decisionReportDataDto.setView(DecisionViewDtoCreator.createCountFrequencyView());
        decisionReportDataDto.setGroupBy(DecisionGroupByDtoCreator.createGroupDecisionByInputVariable((String)variableId, (String)variableName, (VariableType)variableType));
        return decisionReportDataDto;
    }

    private static DecisionReportDataDto createCountFrequencyReportGroupByOutputVariable(List<ReportDataDefinitionDto> definitions, String variableId, String variableName, VariableType variableType) {
        DecisionReportDataDto decisionReportDataDto = new DecisionReportDataDto();
        decisionReportDataDto.setDefinitions(definitions);
        decisionReportDataDto.setVisualization(DecisionVisualization.TABLE);
        decisionReportDataDto.setView(DecisionViewDtoCreator.createCountFrequencyView());
        decisionReportDataDto.setGroupBy(DecisionGroupByDtoCreator.createGroupDecisionByOutputVariable((String)variableId, (String)variableName, (VariableType)variableType));
        return decisionReportDataDto;
    }

    private static DecisionReportDataDto createCountFrequencyReportGroupByMatchedRule(List<ReportDataDefinitionDto> definitions) {
        DecisionReportDataDto decisionReportDataDto = new DecisionReportDataDto();
        decisionReportDataDto.setDefinitions(definitions);
        decisionReportDataDto.setVisualization(DecisionVisualization.TABLE);
        decisionReportDataDto.setView(DecisionViewDtoCreator.createCountFrequencyView());
        decisionReportDataDto.setGroupBy((DecisionGroupByDto)new DecisionGroupByMatchedRuleDto());
        return decisionReportDataDto;
    }
}

