/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.optimize;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.camunda.optimize.rest.optimize.dto.VariableDto;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;

public class VariablesClient {
    private final ObjectMapper objectMapper = new ObjectMapper().setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ")).enable(SerializationFeature.INDENT_OUTPUT);

    public VariableDto createMapJsonObjectVariableDto(Map<String, Object> variable) {
        try {
            return this.createJsonObjectVariableDto(this.objectMapper.writeValueAsString(variable), "java.util.HashMap");
        }
        catch (JsonProcessingException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    public VariableDto createJsonObjectVariableDto(String value, String objectTypeName) {
        VariableDto objectVariableDto = new VariableDto();
        objectVariableDto.setType("Object");
        objectVariableDto.setValue(value);
        VariableDto.ValueInfo info = new VariableDto.ValueInfo();
        info.setObjectTypeName(objectTypeName);
        info.setSerializationDataFormat("application/json");
        objectVariableDto.setValueInfo(info);
        return objectVariableDto;
    }
}

