/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.it.extension.db;

import co.elastic.clients.elasticsearch._types.FieldValue;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import java.util.HashMap;
import java.util.List;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;

public class TermsQueryContainer {
    HashMap<String, List<String>> termQueries = new HashMap();

    public void addTermQuery(String term, List<String> values) {
        this.termQueries.put(term, values);
    }

    public void addTermQuery(String term, String value) {
        this.termQueries.put(term, List.of(value));
    }

    co.elastic.clients.elasticsearch._types.query_dsl.Query toElasticSearchQuery() {
        return co.elastic.clients.elasticsearch._types.query_dsl.Query.of(q -> q.bool(b -> {
            for (String term : this.termQueries.keySet()) {
                b.must(m -> m.terms(t -> t.field(term).terms(tt -> tt.value(this.termQueries.get(term).stream().map(FieldValue::of).toList()))));
            }
            return b;
        }));
    }

    BoolQuery toOpenSearchQuery() {
        BoolQuery.Builder query = new BoolQuery.Builder();
        for (String term : this.termQueries.keySet()) {
            query.must(QueryDSL.stringTerms((String)term, this.termQueries.get(term)), new Query[0]);
        }
        return query.build();
    }
}

