/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.service.util.RoundingUtil;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class RoundingUtilTest {
    @ParameterizedTest
    @MethodSource(value={"roundDownScenarios"})
    public void testRoundDownToNearestPowerOfTen(double input, double expectedOutput) {
        Assertions.assertThat((Double)RoundingUtil.roundDownToNearestPowerOfTen((Double)input)).isEqualTo(expectedOutput);
    }

    private static Stream<Arguments> roundDownScenarios() {
        return Stream.of(Arguments.of((Object[])new Object[]{-11.0, -100.0}), Arguments.of((Object[])new Object[]{-5.0, -10.0}), Arguments.of((Object[])new Object[]{-1.1, -10.0}), Arguments.of((Object[])new Object[]{0.0, 0.0}), Arguments.of((Object[])new Object[]{1.1, 1.0}), Arguments.of((Object[])new Object[]{5.0, 1.0}), Arguments.of((Object[])new Object[]{11.0, 10.0}));
    }

    @ParameterizedTest
    @MethodSource(value={"roundUpScenarios"})
    public void testRoundUpToNearestPowerOfTen(double input, double expectedOutput) {
        Assertions.assertThat((Double)RoundingUtil.roundUpToNearestPowerOfTen((Double)input)).isEqualTo(expectedOutput);
    }

    private static Stream<Arguments> roundUpScenarios() {
        return Stream.of(Arguments.of((Object[])new Object[]{-11.0, -10.0}), Arguments.of((Object[])new Object[]{-5.0, -1.0}), Arguments.of((Object[])new Object[]{-1.1, -1.0}), Arguments.of((Object[])new Object[]{0.0, 0.0}), Arguments.of((Object[])new Object[]{1.1, 10.0}), Arguments.of((Object[])new Object[]{5.0, 10.0}), Arguments.of((Object[])new Object[]{11.0, 100.0}));
    }
}

