/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.service.util.DmnModelUtil;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.camunda.bpm.model.dmn.DmnModelException;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class DmnModelUtilTest {
    private static final String DMN_V1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<definitions xmlns=\"https://www.omg.org/spec/DMN/20191111/MODEL/\"\n   xmlns:dmndi=\"https://www.omg.org/spec/DMN/20191111/DMNDI/\"\n   xmlns:dc=\"http://www.omg.org/spec/DMN/20180521/DC/\"\n   xmlns:biodi=\"http://bpmn.io/schema/dmn/biodi/2.0\"\n   id=\"force_users\" name=\"Force Users\"\n   namespace=\"http://camunda.org/schema/1.0/dmn\" exporter=\"Camunda Modeler\"\n   exporterVersion=\"4.11.0\">\n  <decision id=\"jedi_or_sith\" name=\"Jedi or Sith\">\n    <decisionTable id=\"DecisionTable_14n3bxx\">\n      <input id=\"Input_1\" label=\"Lightsaber color\" biodi:width=\"192\">\n        <inputExpression id=\"InputExpression_1\" typeRef=\"string\">\n          <text>lightsaberColor</text>\n        </inputExpression>\n      </input>\n      <output id=\"Output_1\" label=\"Jedi or Sith\" name=\"jedi_or_sith\">\n        <outputValues id=\"UnaryTests_0hj346a\">\n          <text>\"Jedi\",\"Sith\"</text>\n        </outputValues>\n      </output>\n      <rule id=\"DecisionRule_0zumznl\">\n        <inputEntry id=\"UnaryTests_0leuxqi\">\n          <text>\"blue\"</text>\n        </inputEntry>\n        <outputEntry id=\"LiteralExpression_0c9vpz8\">\n          <text>\"Jedi\"</text>\n        </outputEntry>\n      </rule>\n    </decisionTable>\n  </decision>\n</definitions>\n";

    @Test
    void shouldParseValidXml() {
        DmnModelInstance result = DmnModelUtil.parseDmnModel((String)DMN_V1);
        Assertions.assertThat((Object)result).isNotNull();
    }

    @Test
    void shouldThrowExceptionWhenParsingInvalidXml() {
        String dmnXml = "<invalid></invalid>";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DmnModelUtil.parseDmnModel((String)"<invalid></invalid>")).isInstanceOf(DmnModelException.class)).hasMessage("Unable to parse model");
    }

    @Test
    void shouldExtractDecisionNameWhenExists() {
        String decisionKey = "jedi_or_sith";
        Optional result = DmnModelUtil.extractDecisionDefinitionName((String)"jedi_or_sith", (String)DMN_V1);
        ((OptionalAssert)Assertions.assertThat((Optional)result).isPresent()).get().isEqualTo((Object)"Jedi or Sith");
    }

    @Test
    void shouldReturnEmptyWhenDecisionKeyNotFound() {
        String decisionKey = "nonExistentDecision";
        String dmnXml = "<dmn:definitions xmlns:dmn=\"https://www.omg.org/spec/DMN/20191111/MODEL/\">  <dmn:decision id=\"decision1\" name=\"Test Decision\"/></dmn:definitions>";
        Optional result = DmnModelUtil.extractDecisionDefinitionName((String)"nonExistentDecision", (String)"<dmn:definitions xmlns:dmn=\"https://www.omg.org/spec/DMN/20191111/MODEL/\">  <dmn:decision id=\"decision1\" name=\"Test Decision\"/></dmn:definitions>");
        Assertions.assertThat((Optional)result).isEmpty();
    }

    @Test
    void shouldThrowExceptionWhenInputDecisionKeyIsNull() {
        DmnModelInstance model = (DmnModelInstance)Mockito.mock(DmnModelInstance.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DmnModelUtil.extractInputVariables((DmnModelInstance)model, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("decisionKey must not be null");
    }

    @Test
    void shouldThrowExceptionWhenOutputDecisionKeyIsNull() {
        DmnModelInstance model = (DmnModelInstance)Mockito.mock(DmnModelInstance.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DmnModelUtil.extractOutputVariables((DmnModelInstance)model, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("decisionKey must not be null");
    }
}

