/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.report;

import com.google.common.collect.Sets;
import io.camunda.optimize.dto.optimize.RoleType;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizationType;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemType;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.reader.ReportReader;
import io.camunda.optimize.service.db.writer.ReportWriter;
import io.camunda.optimize.service.exceptions.conflict.OptimizeConflictException;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.relations.ReportRelationService;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.security.AuthorizedCollectionService;
import io.camunda.optimize.service.security.ReportAuthorizationService;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ReportServiceConflictTest {
    @Mock
    ReportWriter reportWriter;
    @Mock
    ReportReader reportReader;
    @Mock
    ReportAuthorizationService authorizationService;
    @Mock
    ReportRelationService reportRelationService;
    @Mock
    AuthorizedCollectionService collectionService;
    @Mock
    AbstractIdentityService abstractIdentityService;
    @Mock
    DefinitionService definitionService;
    private ReportService underTest;

    @BeforeEach
    public void setUp() {
        this.underTest = new ReportService(this.reportWriter, this.reportReader, this.authorizationService, this.reportRelationService, this.collectionService, this.abstractIdentityService, this.definitionService);
        Mockito.when((Object)this.abstractIdentityService.getEnabledAuthorizations()).thenReturn(List.of(AuthorizationType.values()));
    }

    @Test
    public void testUpdateSingleProcessReport() {
        SingleProcessReportDefinitionRequestDto updateDto = new SingleProcessReportDefinitionRequestDto();
        updateDto.setId("test1");
        Mockito.when((Object)this.reportReader.getSingleProcessReportOmitXml("test1")).thenReturn(Optional.of(updateDto));
        Mockito.when((Object)this.authorizationService.getAuthorizedRole((String)ArgumentMatchers.any(), (ReportDefinitionDto)ArgumentMatchers.any())).thenReturn(Optional.of(RoleType.EDITOR));
        Mockito.when((Object)this.authorizationService.isAuthorizedToReport((String)ArgumentMatchers.any(), (ReportDefinitionDto)ArgumentMatchers.any())).thenReturn((Object)true);
        this.underTest.updateSingleProcessReport("test1", updateDto, "user1", false);
        ((ReportWriter)Mockito.verify((Object)this.reportWriter)).updateSingleProcessReport((SingleProcessReportDefinitionUpdateDto)ArgumentMatchers.any());
        ((ReportRelationService)Mockito.verify((Object)this.reportRelationService)).getConflictedItemsForUpdatedReport((ReportDefinitionDto)updateDto, (ReportDefinitionDto)updateDto);
        ((ReportRelationService)Mockito.verify((Object)this.reportRelationService)).handleUpdated("test1", (ReportDefinitionDto)updateDto);
    }

    @Test
    public void testUpdateSingleProcessReportWithConflicts() {
        SingleProcessReportDefinitionRequestDto updateDto = new SingleProcessReportDefinitionRequestDto();
        updateDto.setId("test1");
        Mockito.when((Object)this.reportReader.getSingleProcessReportOmitXml("test1")).thenReturn(Optional.of(updateDto));
        Mockito.when((Object)this.authorizationService.getAuthorizedRole((String)ArgumentMatchers.any(), (ReportDefinitionDto)ArgumentMatchers.any())).thenReturn(Optional.of(RoleType.EDITOR));
        Mockito.when((Object)this.authorizationService.isAuthorizedToReport((String)ArgumentMatchers.any(), (ReportDefinitionDto)ArgumentMatchers.any())).thenReturn((Object)true);
        HashSet conflicts = Sets.newHashSet((Object[])new ConflictedItemDto[]{new ConflictedItemDto("conflict1", ConflictedItemType.ALERT, "name"), new ConflictedItemDto("conflict2", ConflictedItemType.ALERT, "name")});
        Mockito.when((Object)this.reportRelationService.getConflictedItemsForUpdatedReport((ReportDefinitionDto)ArgumentMatchers.any(), (ReportDefinitionDto)ArgumentMatchers.any())).thenReturn((Object)conflicts);
        Assertions.assertThrows(OptimizeConflictException.class, () -> this.underTest.updateSingleProcessReport("test1", updateDto, "user1", false));
    }

    @Test
    public void testUpdateSingleDecisionReport() throws OptimizeConflictException {
        SingleDecisionReportDefinitionRequestDto updateDto = new SingleDecisionReportDefinitionRequestDto();
        updateDto.setId("test1");
        Mockito.when((Object)this.reportReader.getSingleDecisionReportOmitXml("test1")).thenReturn(Optional.of(updateDto));
        Mockito.when((Object)this.authorizationService.isAuthorizedToReport((String)ArgumentMatchers.any(), (ReportDefinitionDto)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationService.getAuthorizedRole((String)ArgumentMatchers.any(), (ReportDefinitionDto)ArgumentMatchers.any())).thenReturn(Optional.of(RoleType.EDITOR));
        this.underTest.updateSingleDecisionReport("test1", updateDto, "user1", false);
        ((ReportWriter)Mockito.verify((Object)this.reportWriter)).updateSingleDecisionReport((SingleDecisionReportDefinitionUpdateDto)ArgumentMatchers.any());
        ((ReportRelationService)Mockito.verify((Object)this.reportRelationService)).getConflictedItemsForUpdatedReport((ReportDefinitionDto)updateDto, (ReportDefinitionDto)updateDto);
        ((ReportRelationService)Mockito.verify((Object)this.reportRelationService)).handleUpdated("test1", (ReportDefinitionDto)updateDto);
    }

    @Test
    public void testUpdateSingleDecisionReportWithConflicts() {
        SingleDecisionReportDefinitionRequestDto updateDto = new SingleDecisionReportDefinitionRequestDto();
        updateDto.setId("test1");
        Mockito.when((Object)this.reportReader.getSingleDecisionReportOmitXml("test1")).thenReturn(Optional.of(updateDto));
        Mockito.when((Object)this.authorizationService.getAuthorizedRole((String)ArgumentMatchers.any(), (ReportDefinitionDto)ArgumentMatchers.any())).thenReturn(Optional.of(RoleType.EDITOR));
        Mockito.when((Object)this.authorizationService.isAuthorizedToReport((String)ArgumentMatchers.any(), (ReportDefinitionDto)ArgumentMatchers.any())).thenReturn((Object)true);
        HashSet conflicts = Sets.newHashSet((Object[])new ConflictedItemDto[]{new ConflictedItemDto("conflict1", ConflictedItemType.ALERT, "name"), new ConflictedItemDto("conflict2", ConflictedItemType.ALERT, "name")});
        Mockito.when((Object)this.reportRelationService.getConflictedItemsForUpdatedReport((ReportDefinitionDto)ArgumentMatchers.any(), (ReportDefinitionDto)ArgumentMatchers.any())).thenReturn((Object)conflicts);
        Assertions.assertThrows(OptimizeConflictException.class, () -> this.underTest.updateSingleDecisionReport("test1", updateDto, "user1", false));
    }

    @Test
    public void testDeleteReport() {
        SingleProcessReportDefinitionRequestDto testDefinition = new SingleProcessReportDefinitionRequestDto();
        Mockito.when((Object)this.reportReader.getReport("test1")).thenReturn(Optional.of(testDefinition));
        Mockito.when((Object)this.authorizationService.getAuthorizedRole((String)ArgumentMatchers.any(), (ReportDefinitionDto)ArgumentMatchers.any())).thenReturn(Optional.of(RoleType.EDITOR));
        this.underTest.deleteReportAsUser("user1", "test1", false);
        ((ReportWriter)Mockito.verify((Object)this.reportWriter)).removeSingleReportFromCombinedReports("test1");
        ((ReportWriter)Mockito.verify((Object)this.reportWriter)).deleteSingleReport("test1");
        ((ReportRelationService)Mockito.verify((Object)this.reportRelationService)).handleDeleted((ReportDefinitionDto)testDefinition);
    }

    @Test
    public void testDeleteReportWithConflicts() {
        Mockito.when((Object)this.reportReader.getReport("test1")).thenReturn(Optional.of(new SingleProcessReportDefinitionRequestDto()));
        Mockito.when((Object)this.authorizationService.getAuthorizedRole((String)ArgumentMatchers.any(), (ReportDefinitionDto)ArgumentMatchers.any())).thenReturn(Optional.of(RoleType.EDITOR));
        HashSet conflicts = Sets.newHashSet((Object[])new ConflictedItemDto[]{new ConflictedItemDto("conflict1", ConflictedItemType.ALERT, "name"), new ConflictedItemDto("conflict2", ConflictedItemType.ALERT, "name")});
        Mockito.when((Object)this.reportRelationService.getConflictedItemsForDeleteReport((ReportDefinitionDto)ArgumentMatchers.any())).thenReturn((Object)conflicts);
        Assertions.assertThrows(OptimizeConflictException.class, () -> this.underTest.deleteReportAsUser("user1", "test1", false));
    }
}

