/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.panelnotification;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.cloud.panelnotifications.PanelNotificationDataDto;
import io.camunda.optimize.dto.optimize.cloud.panelnotifications.PanelNotificationMetaDataDto;
import io.camunda.optimize.dto.optimize.cloud.panelnotifications.PanelNotificationRequestDto;
import io.camunda.optimize.rest.cloud.CCSaaSNotificationClient;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.onboarding.CCSaaSOnboardingPanelNotificationService;
import io.camunda.optimize.service.util.RootUrlGenerator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.ConfigurationServiceBuilder;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class CCSaaSOnboardingPanelNotificationServiceTest {
    private static final String PROCESS_KEY = "aProcessKey";
    private static final String PROCESS_NAME = "aProcessName";
    private static final String ORG_ID = "anOrgId";
    private static final String CLUSTER_ID = "aClusterId";
    @Mock
    private CCSaaSNotificationClient notificationClient;
    @Mock
    private DefinitionService definitionService;
    private CCSaaSOnboardingPanelNotificationService underTest;
    @Mock
    private RootUrlGenerator rootUrlGenerator;

    @BeforeEach
    public void setup() {
        ConfigurationService configurationService = ConfigurationServiceBuilder.createDefaultConfiguration();
        configurationService.getAuthConfiguration().getCloudAuthConfiguration().setOrganizationId(ORG_ID);
        this.underTest = new CCSaaSOnboardingPanelNotificationService(this.notificationClient, configurationService, this.definitionService, this.rootUrlGenerator);
    }

    @Test
    public void panelNotificationDataIsCreatedCorrectly() {
        ProcessDefinitionOptimizeDto returnedDefWithName = new ProcessDefinitionOptimizeDto();
        returnedDefWithName.setName(PROCESS_NAME);
        Mockito.when((Object)this.definitionService.getDefinition((DefinitionType)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenReturn(Optional.of(returnedDefWithName));
        Mockito.when((Object)this.rootUrlGenerator.getRootUrl()).thenReturn((Object)"http://localhost:8090/aClusterId");
        ArgumentCaptor actualNotification = ArgumentCaptor.forClass(PanelNotificationRequestDto.class);
        this.underTest.sendOnboardingPanelNotification(PROCESS_KEY);
        ((CCSaaSNotificationClient)Mockito.verify((Object)this.notificationClient)).sendPanelNotificationToOrg((PanelNotificationRequestDto)actualNotification.capture());
        Assertions.assertThat((Object)((PanelNotificationRequestDto)actualNotification.getValue()).getNotification()).isEqualTo((Object)this.createExpectedNotificationDataDto());
    }

    private PanelNotificationDataDto createExpectedNotificationDataDto() {
        return PanelNotificationDataDto.builder().uniqueId("initialVisitToInstantDashboard_aProcessKey").source("optimize").type("org").orgId(ORG_ID).title("See how your process is doing").description("Your first process of aProcessName was started successfully. Track the status in the instant preview dashboard.").meta(this.createExpectedPanelNotificationMetadataDto()).build();
    }

    private PanelNotificationMetaDataDto createExpectedPanelNotificationMetadataDto() {
        return PanelNotificationMetaDataDto.builder().permissions(new String[]{"cluster:optimize:read"}).identifier("initialVisitToInstantDashboard").href(String.format("http://localhost:8090/%s/#/dashboard/instant/%s", CLUSTER_ID, PROCESS_KEY)).label("View instant preview dashboard").build();
    }
}

