/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.mixpanel;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.CharStreams;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.mixpanel.client.EventReportingEvent;
import io.camunda.optimize.service.mixpanel.client.MixpanelClient;
import io.camunda.optimize.service.mixpanel.client.MixpanelEvent;
import io.camunda.optimize.service.mixpanel.client.MixpanelEventProperties;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.ConfigurationServiceBuilder;
import io.camunda.optimize.service.util.configuration.analytics.MixpanelConfiguration;
import io.github.netmikey.logunit.api.LogCapturer;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.http.HttpStatus;

@ExtendWith(value={MockitoExtension.class})
public class MixpanelClientTest {
    @RegisterExtension
    protected final LogCapturer logCapturer = LogCapturer.create().captureForType(MixpanelClient.class);
    private final ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final ConfigurationService configurationService = ConfigurationServiceBuilder.createDefaultConfiguration();
    @Mock
    private CloseableHttpClient httpClient;
    private MixpanelClient mixpanelClient;

    @BeforeEach
    public void setup() {
        this.mixpanelClient = new MixpanelClient(this.configurationService, this.objectMapper, this.httpClient);
    }

    @Test
    public void mixpanelEventImportWithExpectedParametersAndPayload() {
        String username = "username";
        String secret = "secret";
        this.getMixpanelConfiguration().getServiceAccount().setUsername("username");
        this.getMixpanelConfiguration().getServiceAccount().setSecret("secret");
        CloseableHttpResponse mockResponse = this.mockResponseWithStatus(HttpStatus.OK);
        Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)new StringEntity("{}", ContentType.APPLICATION_JSON));
        try {
            Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)mockResponse);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        String stage = "unit-test";
        String organizationId = "orgId";
        String clusterId = "clusterId";
        MixpanelEventProperties mixpanelEventProperties = new MixpanelEventProperties("unit-test", "orgId", "clusterId");
        this.mixpanelClient.importEvent(new MixpanelEvent(EventReportingEvent.HEARTBEAT, mixpanelEventProperties));
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpPost.class);
        try {
            ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)1))).execute((HttpUriRequest)requestCaptor.capture());
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        Assertions.assertThat((String)((HttpPost)requestCaptor.getValue()).getURI().toString()).startsWith((CharSequence)this.getMixpanelConfiguration().getImportUrl());
        Assertions.assertThat((String)((HttpPost)requestCaptor.getValue()).getURI().getQuery()).isEqualTo("strict=1&project_id=" + this.getMixpanelConfiguration().getProjectId());
        Assertions.assertThat((String)((HttpPost)requestCaptor.getValue()).getMethod()).isEqualTo("POST");
        Assertions.assertThat((String)((HttpPost)requestCaptor.getValue()).getFirstHeader("Content-Type").getValue()).isEqualTo("application/json");
        Assertions.assertThat((String)((HttpPost)requestCaptor.getValue()).getFirstHeader("Authorization").getValue()).satisfies(new ThrowingConsumer[]{authHeaderValue -> {
            Assertions.assertThat((String)authHeaderValue).contains(new CharSequence[]{"Basic "});
            String plainCredentials = new String(Base64.getDecoder().decode(authHeaderValue.split("\\s")[1]), StandardCharsets.UTF_8);
            Assertions.assertThat((Object[])plainCredentials.split(":")).containsExactly((Object[])new String[]{"username", "secret"});
        }});
        MixpanelEvent recordedMixpanelEvent = this.readMixpanelEventFromRequest((ArgumentCaptor<HttpPost>)requestCaptor);
        Assertions.assertThat((String)recordedMixpanelEvent.getEvent()).isEqualTo("optimize:" + String.valueOf(EventReportingEvent.HEARTBEAT));
        Assertions.assertThat((Object)recordedMixpanelEvent.getProperties()).isEqualTo((Object)mixpanelEventProperties);
    }

    @Test
    public void mixpanelEventImportFailsOnNonOkStatusCode() {
        String username = "username";
        String secret = "secret";
        this.getMixpanelConfiguration().getServiceAccount().setUsername("username");
        this.getMixpanelConfiguration().getServiceAccount().setSecret("secret");
        CloseableHttpResponse mockResponse = this.mockResponseWithStatus(HttpStatus.BAD_REQUEST);
        Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)new StringEntity("{}", ContentType.APPLICATION_JSON));
        try {
            Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)mockResponse);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        MixpanelEvent event = new MixpanelEvent(EventReportingEvent.HEARTBEAT, new MixpanelEventProperties());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.mixpanelClient.importEvent(event)).isInstanceOf(OptimizeRuntimeException.class)).hasMessage("Unexpected response status on a mixpanel import: 400, response body: {}");
    }

    @Test
    public void mixpanelEventImportFailsOnErrorInResponseBody() {
        String username = "username";
        String secret = "secret";
        this.getMixpanelConfiguration().getServiceAccount().setUsername("username");
        this.getMixpanelConfiguration().getServiceAccount().setSecret("secret");
        CloseableHttpResponse mockResponse = this.mockResponseWithStatus(HttpStatus.OK);
        Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)new StringEntity("{\"error\":\"failure\"}", ContentType.APPLICATION_JSON));
        try {
            Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)mockResponse);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        MixpanelEvent event = new MixpanelEvent(EventReportingEvent.HEARTBEAT, new MixpanelEventProperties());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.mixpanelClient.importEvent(event)).isInstanceOf(OptimizeRuntimeException.class)).hasMessage("Mixpanel import was not successful, error: failure");
    }

    @Test
    public void mixpanelEventImportInvalidJsonResponseIsHandledGracefullyButLogged() {
        String username = "username";
        String secret = "secret";
        this.getMixpanelConfiguration().getServiceAccount().setUsername("username");
        this.getMixpanelConfiguration().getServiceAccount().setSecret("secret");
        CloseableHttpResponse mockResponse = this.mockResponseWithStatus(HttpStatus.OK);
        Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)new StringEntity("{\"error\":", ContentType.APPLICATION_JSON));
        try {
            Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)mockResponse);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        this.mixpanelClient.importEvent(new MixpanelEvent(EventReportingEvent.HEARTBEAT, new MixpanelEventProperties()));
        this.logCapturer.assertContains("Could not parse response from Mixpanel.");
    }

    private CloseableHttpResponse mockResponseWithStatus(HttpStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("status cannot be null");
        }
        CloseableHttpResponse mockResponse = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        StatusLine mockStatusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)mockStatusLine.getStatusCode()).thenReturn((Object)status.value());
        Mockito.when((Object)mockResponse.getStatusLine()).thenReturn((Object)mockStatusLine);
        return mockResponse;
    }

    private MixpanelConfiguration getMixpanelConfiguration() {
        return this.configurationService.getAnalytics().getMixpanel();
    }

    private MixpanelEvent readMixpanelEventFromRequest(ArgumentCaptor<HttpPost> requestCaptor) {
        MixpanelEvent mixpanelEvent;
        InputStreamReader reader = new InputStreamReader(((HttpPost)requestCaptor.getValue()).getEntity().getContent());
        try {
            mixpanelEvent = ((MixpanelEvent[])this.objectMapper.readValue(CharStreams.toString((Readable)reader), MixpanelEvent[].class))[0];
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OptimizeRuntimeException((Throwable)e);
            }
        }
        ((Reader)reader).close();
        return mixpanelEvent;
    }
}

