/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing;

import io.camunda.client.api.response.ProcessInstanceEvent;
import io.camunda.optimize.AbstractCCSMIT;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.importing.UserTaskIdentityOperationType;
import io.camunda.optimize.dto.optimize.persistence.AssigneeOperationDto;
import io.camunda.optimize.dto.optimize.query.process.FlowNodeInstanceDto;
import io.camunda.optimize.dto.zeebe.ZeebeRecordDto;
import io.camunda.optimize.dto.zeebe.usertask.ZeebeUserTaskDataDto;
import io.camunda.optimize.dto.zeebe.usertask.ZeebeUserTaskRecordDto;
import io.camunda.optimize.util.ZeebeBpmnModels;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIf;

@DisabledIf(value="isZeebeVersionPre86")
public class ZeebeUserTaskImportIT
extends AbstractCCSMIT {
    private static final String TEST_PROCESS = "aProcess";
    private static final String DUE_DATE = "2024-07-24T00:00Z[GMT]";
    private static final OffsetDateTime EXPECTED_DUE_DATE = OffsetDateTime.parse("2024-07-24T00:00Z");
    private static final String ASSIGNEE_ID = "assigneeId";

    @Test
    public void importRunningZeebeUserTaskData() {
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcess(TEST_PROCESS, DUE_DATE));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromScratch();
        List<ZeebeUserTaskRecordDto> exportedEvents = this.getZeebeExportedUserTaskEvents();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(instance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(instance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(instance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            FlowNodeInstanceDto runningUserTaskInstance = this.createRunningUserTaskInstance(instance, exportedEvents);
            runningUserTaskInstance.setDueDate(EXPECTED_DUE_DATE);
            ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).usingRecursiveComparison().isEqualTo((Object)runningUserTaskInstance);
        }});
    }

    @Test
    public void importCompletedUnclaimedZeebeUserTaskData_viaWriter() {
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcess(TEST_PROCESS, DUE_DATE));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        List<ZeebeUserTaskRecordDto> userTaskEvents = this.getZeebeExportedUserTaskEvents();
        zeebeExtension.completeZeebeUserTask(this.getExpectedUserTaskInstanceIdFromRecords(userTaskEvents));
        this.waitUntilUserTaskRecordWithIntentExported(UserTaskIntent.COMPLETED);
        this.importAllZeebeEntitiesFromScratch();
        userTaskEvents = this.getZeebeExportedUserTaskEvents();
        OffsetDateTime expectedEndDate = this.getExpectedEndDateForCompletedUserTaskEvents(userTaskEvents);
        FlowNodeInstanceDto expectedUserTask = this.createRunningUserTaskInstance(instance, userTaskEvents);
        expectedUserTask.setDueDate(EXPECTED_DUE_DATE);
        expectedUserTask.setEndDate(expectedEndDate);
        expectedUserTask.setIdleDurationInMs(Long.valueOf(0L));
        expectedUserTask.setTotalDurationInMs(Long.valueOf(this.getExpectedTotalDurationForCompletedUserTask(userTaskEvents)));
        expectedUserTask.setWorkDurationInMs(Long.valueOf(this.getExpectedTotalDurationForCompletedUserTask(userTaskEvents)));
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(instance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(instance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(instance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).usingRecursiveComparison().isEqualTo((Object)expectedUserTask);
        }});
    }

    @Test
    public void importCompletedUnclaimedZeebeUserTaskData_viaUpdateScript() {
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcess(TEST_PROCESS, DUE_DATE));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromScratch();
        List<ZeebeUserTaskRecordDto> runningUserTaskEvents = this.getZeebeExportedUserTaskEvents();
        FlowNodeInstanceDto expectedUserTask = this.createRunningUserTaskInstance(instance, runningUserTaskEvents);
        List<ZeebeUserTaskRecordDto> userTaskEvents = this.getZeebeExportedUserTaskEvents();
        zeebeExtension.completeZeebeUserTask(this.getExpectedUserTaskInstanceIdFromRecords(userTaskEvents));
        this.waitUntilUserTaskRecordWithIntentExported(UserTaskIntent.COMPLETED);
        this.importAllZeebeEntitiesFromLastIndex();
        userTaskEvents = this.getZeebeExportedUserTaskEvents();
        OffsetDateTime expectedEndDate = this.getExpectedEndDateForCompletedUserTaskEvents(userTaskEvents);
        expectedUserTask.setDueDate(EXPECTED_DUE_DATE);
        expectedUserTask.setEndDate(expectedEndDate);
        expectedUserTask.setIdleDurationInMs(Long.valueOf(0L));
        expectedUserTask.setTotalDurationInMs(Long.valueOf(this.getExpectedTotalDurationForCompletedUserTask(userTaskEvents)));
        expectedUserTask.setWorkDurationInMs(Long.valueOf(this.getExpectedTotalDurationForCompletedUserTask(userTaskEvents)));
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(instance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(instance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(instance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).usingRecursiveComparison().isEqualTo((Object)expectedUserTask);
        }});
    }

    @Test
    public void importCanceledUnclaimedZeebeUserTaskData_viaWriter() {
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcess(TEST_PROCESS, DUE_DATE));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        zeebeExtension.cancelProcessInstance(instance.getProcessInstanceKey());
        this.waitUntilUserTaskRecordWithIntentExported(UserTaskIntent.CANCELED);
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromScratch();
        List<ZeebeUserTaskRecordDto> exportedEvents = this.getZeebeExportedUserTaskEvents();
        FlowNodeInstanceDto expectedUserTask = this.createRunningUserTaskInstance(instance, exportedEvents);
        OffsetDateTime expectedEndDate = this.getExpectedEndDateForCanceledUserTaskEvents(exportedEvents);
        Long expectedTotalAndIdleDuration = Duration.between(expectedUserTask.getStartDate(), expectedEndDate).toMillis();
        expectedUserTask.setDueDate(EXPECTED_DUE_DATE);
        expectedUserTask.setEndDate(expectedEndDate);
        expectedUserTask.setTotalDurationInMs(expectedTotalAndIdleDuration);
        expectedUserTask.setIdleDurationInMs(expectedTotalAndIdleDuration);
        expectedUserTask.setWorkDurationInMs(Long.valueOf(0L));
        expectedUserTask.setCanceled(Boolean.valueOf(true));
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(instance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(instance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(instance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).usingRecursiveComparison().isEqualTo((Object)expectedUserTask);
        }});
    }

    @Test
    public void importCanceledUnclaimedZeebeUserTaskData_viaUpdateScript() {
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcess(TEST_PROCESS, DUE_DATE));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromScratch();
        zeebeExtension.cancelProcessInstance(instance.getProcessInstanceKey());
        this.waitUntilUserTaskRecordWithIntentExported(UserTaskIntent.CANCELED);
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromLastIndex();
        List<ZeebeUserTaskRecordDto> exportedEvents = this.getZeebeExportedUserTaskEvents();
        FlowNodeInstanceDto expectedUserTask = this.createRunningUserTaskInstance(instance, exportedEvents);
        OffsetDateTime expectedEndDate = this.getExpectedEndDateForCanceledUserTaskEvents(exportedEvents);
        expectedUserTask.setDueDate(EXPECTED_DUE_DATE);
        expectedUserTask.setEndDate(expectedEndDate);
        expectedUserTask.setTotalDurationInMs(Long.valueOf(Duration.between(expectedUserTask.getStartDate(), expectedEndDate).toMillis()));
        expectedUserTask.setIdleDurationInMs(Long.valueOf(Duration.between(expectedUserTask.getStartDate(), expectedEndDate).toMillis()));
        expectedUserTask.setWorkDurationInMs(Long.valueOf(0L));
        expectedUserTask.setCanceled(Boolean.valueOf(true));
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(instance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(instance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(instance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).usingRecursiveComparison().isEqualTo((Object)expectedUserTask);
        }});
    }

    @Test
    public void importCanceledClaimedZeebeUserTaskData_viaWriter() {
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcess(TEST_PROCESS, DUE_DATE));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        List<ZeebeUserTaskRecordDto> exportedEvents = this.getZeebeExportedUserTaskEvents();
        zeebeExtension.assignUserTask(this.getExpectedUserTaskInstanceIdFromRecords(exportedEvents), ASSIGNEE_ID);
        zeebeExtension.cancelProcessInstance(instance.getProcessInstanceKey());
        this.waitUntilUserTaskRecordWithIntentExported(UserTaskIntent.CANCELED);
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromScratch();
        exportedEvents = this.getZeebeExportedUserTaskEvents();
        FlowNodeInstanceDto expectedUserTask = this.createRunningUserTaskInstance(instance, exportedEvents);
        OffsetDateTime expectedEndDate = this.getExpectedEndDateForCanceledUserTaskEvents(exportedEvents);
        OffsetDateTime assignDate = this.getTimestampForAssignedUserTaskEvents(exportedEvents);
        expectedUserTask.setAssignee(ASSIGNEE_ID);
        expectedUserTask.setDueDate(EXPECTED_DUE_DATE);
        expectedUserTask.setEndDate(expectedEndDate);
        expectedUserTask.setTotalDurationInMs(Long.valueOf(Duration.between(expectedUserTask.getStartDate(), expectedEndDate).toMillis()));
        expectedUserTask.setIdleDurationInMs(Long.valueOf(Duration.between(expectedUserTask.getStartDate(), assignDate).toMillis()));
        expectedUserTask.setWorkDurationInMs(Long.valueOf(Duration.between(assignDate, expectedEndDate).toMillis()));
        expectedUserTask.setAssigneeOperations(List.of(this.createAssigneeOperationDto(this.getExpectedIdFromRecords(exportedEvents, UserTaskIntent.ASSIGNED), UserTaskIdentityOperationType.CLAIM_OPERATION_TYPE, ASSIGNEE_ID, this.getTimestampForAssignedUserTaskEvents(exportedEvents))));
        expectedUserTask.setCanceled(Boolean.valueOf(true));
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(instance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(instance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(instance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).usingRecursiveComparison().isEqualTo((Object)expectedUserTask);
        }});
    }

    @Test
    public void importCanceledClaimedZeebeUserTaskData_viaUpdateScript() {
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcess(TEST_PROCESS, DUE_DATE));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        List<ZeebeUserTaskRecordDto> exportedEvents = this.getZeebeExportedUserTaskEvents();
        zeebeExtension.assignUserTask(this.getExpectedUserTaskInstanceIdFromRecords(exportedEvents), ASSIGNEE_ID);
        this.waitUntilUserTaskRecordWithIntentExported(UserTaskIntent.ASSIGNED);
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromScratch();
        zeebeExtension.cancelProcessInstance(instance.getProcessInstanceKey());
        this.waitUntilUserTaskRecordWithIntentExported(UserTaskIntent.CANCELED);
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromLastIndex();
        exportedEvents = this.getZeebeExportedUserTaskEvents();
        OffsetDateTime expectedEndDate = this.getExpectedEndDateForCanceledUserTaskEvents(exportedEvents);
        OffsetDateTime assignDate = this.getTimestampForAssignedUserTaskEvents(exportedEvents);
        FlowNodeInstanceDto expectedUserTask = this.createRunningUserTaskInstance(instance, exportedEvents);
        expectedUserTask.setAssignee(ASSIGNEE_ID);
        expectedUserTask.setDueDate(EXPECTED_DUE_DATE);
        expectedUserTask.setEndDate(expectedEndDate);
        expectedUserTask.setTotalDurationInMs(Long.valueOf(Duration.between(expectedUserTask.getStartDate(), expectedEndDate).toMillis()));
        expectedUserTask.setIdleDurationInMs(Long.valueOf(Duration.between(expectedUserTask.getStartDate(), assignDate).toMillis()));
        expectedUserTask.setWorkDurationInMs(Long.valueOf(Duration.between(assignDate, expectedEndDate).toMillis()));
        expectedUserTask.setAssigneeOperations(List.of(this.createAssigneeOperationDto(this.getExpectedIdFromRecords(exportedEvents, UserTaskIntent.ASSIGNED), UserTaskIdentityOperationType.CLAIM_OPERATION_TYPE, ASSIGNEE_ID, this.getTimestampForAssignedUserTaskEvents(exportedEvents))));
        expectedUserTask.setCanceled(Boolean.valueOf(true));
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(instance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(instance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(instance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).usingRecursiveComparison().isEqualTo((Object)expectedUserTask);
        }});
    }

    @Test
    public void importClaimOperation_viaWriter() {
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcess(TEST_PROCESS, null));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        List<ZeebeUserTaskRecordDto> exportedEvents = this.getZeebeExportedUserTaskEvents();
        zeebeExtension.assignUserTask(this.getExpectedUserTaskInstanceIdFromRecords(exportedEvents), ASSIGNEE_ID);
        this.waitUntilUserTaskRecordWithIntentExported(UserTaskIntent.ASSIGNED);
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromScratch();
        exportedEvents = this.getZeebeExportedUserTaskEvents();
        FlowNodeInstanceDto expectedUserTask = this.createRunningUserTaskInstance(instance, exportedEvents);
        expectedUserTask.setIdleDurationInMs(Long.valueOf(this.getDurationInMsBetweenStartAndFirstAssignOperation(exportedEvents)));
        expectedUserTask.setAssignee(ASSIGNEE_ID);
        expectedUserTask.setAssigneeOperations(List.of(this.createAssigneeOperationDto(this.getExpectedIdFromRecords(exportedEvents, UserTaskIntent.ASSIGNED), UserTaskIdentityOperationType.CLAIM_OPERATION_TYPE, ASSIGNEE_ID, this.getTimestampForZeebeAssignEvents(exportedEvents, ASSIGNEE_ID))));
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(instance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(instance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(instance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).usingRecursiveComparison().isEqualTo((Object)expectedUserTask);
        }});
    }

    @Test
    public void importClaimOperation_viaUpdateScript() {
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcess(TEST_PROCESS, null));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromScratch();
        List<ZeebeUserTaskRecordDto> exportedEvents = this.getZeebeExportedUserTaskEvents();
        zeebeExtension.assignUserTask(this.getExpectedUserTaskInstanceIdFromRecords(exportedEvents), ASSIGNEE_ID);
        this.waitUntilUserTaskRecordWithIntentExported(UserTaskIntent.ASSIGNED);
        this.importAllZeebeEntitiesFromLastIndex();
        exportedEvents = this.getZeebeExportedUserTaskEvents();
        FlowNodeInstanceDto expectedUserTask = this.createRunningUserTaskInstance(instance, exportedEvents);
        expectedUserTask.setIdleDurationInMs(Long.valueOf(this.getDurationInMsBetweenStartAndFirstAssignOperation(exportedEvents)));
        expectedUserTask.setAssignee(ASSIGNEE_ID);
        expectedUserTask.setAssigneeOperations(List.of(this.createAssigneeOperationDto(this.getExpectedIdFromRecords(exportedEvents, UserTaskIntent.ASSIGNED), UserTaskIdentityOperationType.CLAIM_OPERATION_TYPE, ASSIGNEE_ID, this.getTimestampForZeebeAssignEvents(exportedEvents, ASSIGNEE_ID))));
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(instance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(instance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(instance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).usingRecursiveComparison().isEqualTo((Object)expectedUserTask);
        }});
    }

    @Test
    public void importUnclaimOperation_viaWriter() {
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcessWithAssignee(TEST_PROCESS, null, ASSIGNEE_ID));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        if (ZeebeUserTaskImportIT.isZeebeVersion87_OrLater()) {
            this.waitUntilUserTaskRecordWithIntentExported(1L, UserTaskIntent.ASSIGNED);
            zeebeExtension.unassignUserTask(this.getExpectedUserTaskInstanceIdFromRecords(this.getZeebeExportedUserTaskEvents()));
            this.waitUntilUserTaskRecordWithIntentExported(2L, UserTaskIntent.ASSIGNED);
        } else {
            zeebeExtension.unassignUserTask(this.getExpectedUserTaskInstanceIdFromRecords(this.getZeebeExportedUserTaskEvents()));
            this.waitUntilUserTaskRecordWithIntentExported(UserTaskIntent.ASSIGNED);
        }
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromScratch();
        List<ZeebeUserTaskRecordDto> exportedEvents = this.getZeebeExportedUserTaskEvents();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(instance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(instance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(instance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            FlowNodeInstanceDto runningUserTaskInstance = this.createRunningUserTaskInstance(instance, exportedEvents);
            runningUserTaskInstance.setIdleDurationInMs(Long.valueOf(0L));
            runningUserTaskInstance.setWorkDurationInMs(Long.valueOf(ZeebeUserTaskImportIT.isZeebeVersion87_OrLater() ? this.getDurationInMsBetweenStartDateAndLastAssignedOperation(exportedEvents) : this.getDurationInMsBetweenStartAndFirstAssignOperation(exportedEvents)));
            runningUserTaskInstance.setAssigneeOperations(List.of(this.createAssigneeOperationDto(this.getExpectedIdFromRecords(exportedEvents, UserTaskIntent.CREATING), UserTaskIdentityOperationType.CLAIM_OPERATION_TYPE, ASSIGNEE_ID, this.getExpectedStartDateForUserTaskEvents(exportedEvents)), this.createAssigneeOperationDto(this.getExpectedIdFromRecords(exportedEvents, UserTaskIntent.ASSIGNED), UserTaskIdentityOperationType.UNCLAIM_OPERATION_TYPE, null, this.getTimestampForLastZeebeEventsWithIntent(exportedEvents, (Intent)UserTaskIntent.ASSIGNED))));
            ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).usingRecursiveComparison().isEqualTo((Object)runningUserTaskInstance);
        }});
    }

    @Test
    public void importUnclaimOperation_viaUpdateScript() {
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcessWithAssignee(TEST_PROCESS, null, ASSIGNEE_ID));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromScratch();
        List<ZeebeUserTaskRecordDto> exportedEvents = this.getZeebeExportedUserTaskEvents();
        if (ZeebeUserTaskImportIT.isZeebeVersion87_OrLater()) {
            this.waitUntilUserTaskRecordWithIntentExported(1L, UserTaskIntent.ASSIGNED);
            zeebeExtension.unassignUserTask(this.getExpectedUserTaskInstanceIdFromRecords(this.getZeebeExportedUserTaskEvents()));
            this.waitUntilUserTaskRecordWithIntentExported(2L, UserTaskIntent.ASSIGNED);
        } else {
            zeebeExtension.unassignUserTask(this.getExpectedUserTaskInstanceIdFromRecords(exportedEvents));
            this.waitUntilUserTaskRecordWithIntentExported(UserTaskIntent.ASSIGNED);
        }
        this.importAllZeebeEntitiesFromLastIndex();
        exportedEvents = this.getZeebeExportedUserTaskEvents();
        FlowNodeInstanceDto expectedUserTask = this.createRunningUserTaskInstance(instance, exportedEvents);
        expectedUserTask.setIdleDurationInMs(Long.valueOf(0L));
        expectedUserTask.setWorkDurationInMs(Long.valueOf(ZeebeUserTaskImportIT.isZeebeVersion87_OrLater() ? this.getDurationInMsBetweenStartDateAndLastAssignedOperation(exportedEvents) : this.getDurationInMsBetweenStartAndFirstAssignOperation(exportedEvents)));
        expectedUserTask.setAssigneeOperations(List.of(this.createAssigneeOperationDto(this.getExpectedIdFromRecords(exportedEvents, UserTaskIntent.CREATING), UserTaskIdentityOperationType.CLAIM_OPERATION_TYPE, ASSIGNEE_ID, this.getExpectedStartDateForUserTaskEvents(exportedEvents)), this.createAssigneeOperationDto(this.getExpectedIdFromRecords(exportedEvents, UserTaskIntent.ASSIGNED), UserTaskIdentityOperationType.UNCLAIM_OPERATION_TYPE, null, ZeebeUserTaskImportIT.isZeebeVersion87_OrLater() ? this.getTimestampForZeebeLastAssignedEvents(exportedEvents, "") : this.getTimestampForZeebeUnassignEvent(exportedEvents))));
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(instance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(instance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(instance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).usingRecursiveComparison().isEqualTo((Object)expectedUserTask);
        }});
    }

    @Test
    public void importAssignee_fromCreationRecord() {
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcessWithAssignee(TEST_PROCESS, DUE_DATE, ASSIGNEE_ID));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromScratch();
        List<ZeebeUserTaskRecordDto> exportedEvents = this.getZeebeExportedUserTaskEvents();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(instance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(instance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(instance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            FlowNodeInstanceDto runningUserTaskInstance = this.createRunningUserTaskInstance(instance, exportedEvents);
            runningUserTaskInstance.setDueDate(EXPECTED_DUE_DATE);
            runningUserTaskInstance.setIdleDurationInMs(Long.valueOf(0L));
            runningUserTaskInstance.setAssignee(ASSIGNEE_ID);
            runningUserTaskInstance.setAssigneeOperations(List.of(this.createAssigneeOperationDto(this.getExpectedIdFromRecords(exportedEvents, UserTaskIntent.CREATING), UserTaskIdentityOperationType.CLAIM_OPERATION_TYPE, ASSIGNEE_ID, this.getExpectedStartDateForUserTaskEvents(exportedEvents))));
            ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).usingRecursiveComparison().isEqualTo((Object)runningUserTaskInstance);
        }});
    }

    @Test
    public void importMultipleAssigneeOperations_viaWriter() {
        String assigneeId1 = "assigneeId1";
        String assigneeId2 = "assigneeId2";
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcess(TEST_PROCESS, null));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        List<ZeebeUserTaskRecordDto> userTaskEvents = this.getZeebeExportedUserTaskEvents();
        long userTaskInstanceId = this.getExpectedUserTaskInstanceIdFromRecords(userTaskEvents);
        zeebeExtension.assignUserTask(userTaskInstanceId, "assigneeId1");
        zeebeExtension.unassignUserTask(userTaskInstanceId);
        zeebeExtension.assignUserTask(userTaskInstanceId, "assigneeId2");
        zeebeExtension.completeZeebeUserTask(userTaskInstanceId);
        this.waitUntilUserTaskRecordWithIntentExported(UserTaskIntent.COMPLETED);
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromScratch();
        List<ZeebeUserTaskRecordDto> exportedEvents = this.getZeebeExportedUserTaskEvents();
        FlowNodeInstanceDto runningUserTaskInstance = this.createRunningUserTaskInstance(instance, exportedEvents);
        runningUserTaskInstance.setEndDate(this.getExpectedEndDateForCompletedUserTaskEvents(exportedEvents));
        runningUserTaskInstance.setIdleDurationInMs(Long.valueOf(this.getDurationInMsBetweenStartAndFirstAssignOperation(exportedEvents) + this.getDurationInMsBetweenAssignOperations(exportedEvents, "", "assigneeId2")));
        runningUserTaskInstance.setWorkDurationInMs(Long.valueOf(this.getDurationInMsBetweenAssignOperations(exportedEvents, "assigneeId1", "") + this.getDurationInMsBetweenLastAssignOperationAndEnd(exportedEvents, "assigneeId2")));
        runningUserTaskInstance.setTotalDurationInMs(Long.valueOf(this.getExpectedTotalDurationForCompletedUserTask(exportedEvents)));
        runningUserTaskInstance.setAssignee("assigneeId2");
        runningUserTaskInstance.setAssigneeOperations(List.of(this.createAssigneeOperationDto(this.getExpectedIdFromAssignRecordsWithAssigneeId(exportedEvents, "assigneeId1"), UserTaskIdentityOperationType.CLAIM_OPERATION_TYPE, "assigneeId1", this.getTimestampForZeebeAssignEvents(exportedEvents, "assigneeId1")), this.createAssigneeOperationDto(this.getExpectedIdFromAssignRecordsWithAssigneeId(exportedEvents, ""), UserTaskIdentityOperationType.UNCLAIM_OPERATION_TYPE, null, this.getTimestampForZeebeUnassignEvent(exportedEvents)), this.createAssigneeOperationDto(this.getExpectedIdFromAssignRecordsWithAssigneeId(exportedEvents, "assigneeId2"), UserTaskIdentityOperationType.CLAIM_OPERATION_TYPE, "assigneeId2", this.getTimestampForZeebeAssignEvents(exportedEvents, "assigneeId2"))));
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).usingRecursiveComparison().isEqualTo((Object)runningUserTaskInstance)});
    }

    @Test
    public void importMultipleAssigneeOperations_viaUpdateScript() {
        String assigneeId1 = "assigneeId1";
        String assigneeId2 = "assigneeId2";
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcess(TEST_PROCESS, null));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        List<ZeebeUserTaskRecordDto> userTaskEvents = this.getZeebeExportedUserTaskEvents();
        long userTaskInstanceId = this.getExpectedUserTaskInstanceIdFromRecords(userTaskEvents);
        zeebeExtension.assignUserTask(userTaskInstanceId, "assigneeId1");
        this.waitUntilUserTaskRecordWithIntentExported(UserTaskIntent.ASSIGNED);
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromScratch();
        zeebeExtension.unassignUserTask(userTaskInstanceId);
        zeebeExtension.assignUserTask(userTaskInstanceId, "assigneeId2");
        zeebeExtension.completeZeebeUserTask(userTaskInstanceId);
        this.waitUntilUserTaskRecordWithIntentExported(UserTaskIntent.COMPLETED);
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromLastIndex();
        List<ZeebeUserTaskRecordDto> exportedEvents = this.getZeebeExportedUserTaskEvents();
        FlowNodeInstanceDto runningUserTaskInstance = this.createRunningUserTaskInstance(instance, exportedEvents);
        runningUserTaskInstance.setEndDate(this.getExpectedEndDateForCompletedUserTaskEvents(exportedEvents));
        runningUserTaskInstance.setIdleDurationInMs(Long.valueOf(this.getDurationInMsBetweenStartAndFirstAssignOperation(exportedEvents) + this.getDurationInMsBetweenAssignOperations(exportedEvents, "", "assigneeId2")));
        runningUserTaskInstance.setWorkDurationInMs(Long.valueOf(this.getDurationInMsBetweenAssignOperations(exportedEvents, "assigneeId1", "") + this.getDurationInMsBetweenLastAssignOperationAndEnd(exportedEvents, "assigneeId2")));
        runningUserTaskInstance.setTotalDurationInMs(Long.valueOf(this.getExpectedTotalDurationForCompletedUserTask(exportedEvents)));
        runningUserTaskInstance.setAssignee("assigneeId2");
        runningUserTaskInstance.setAssigneeOperations(List.of(this.createAssigneeOperationDto(this.getExpectedIdFromAssignRecordsWithAssigneeId(exportedEvents, "assigneeId1"), UserTaskIdentityOperationType.CLAIM_OPERATION_TYPE, "assigneeId1", this.getTimestampForZeebeAssignEvents(exportedEvents, "assigneeId1")), this.createAssigneeOperationDto(this.getExpectedIdFromAssignRecordsWithAssigneeId(exportedEvents, ""), UserTaskIdentityOperationType.UNCLAIM_OPERATION_TYPE, null, this.getTimestampForZeebeUnassignEvent(exportedEvents)), this.createAssigneeOperationDto(this.getExpectedIdFromAssignRecordsWithAssigneeId(exportedEvents, "assigneeId2"), UserTaskIdentityOperationType.CLAIM_OPERATION_TYPE, "assigneeId2", this.getTimestampForZeebeAssignEvents(exportedEvents, "assigneeId2"))));
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).usingRecursiveComparison().isEqualTo((Object)runningUserTaskInstance)});
    }

    @Test
    public void doNotImportCandidateGroupUpdates() {
        this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcessWithCandidateGroup(TEST_PROCESS, DUE_DATE, "aCandidateGroup"));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        List<ZeebeUserTaskRecordDto> exportedEvents = this.getZeebeExportedUserTaskEvents();
        zeebeExtension.updateCandidateGroupForUserTask(this.getExpectedUserTaskInstanceIdFromRecords(exportedEvents), "anotherCandidateGroup");
        this.importAllZeebeEntitiesFromScratch();
        Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).flatExtracting(ProcessInstanceDto::getFlowNodeInstances).extracting(FlowNodeInstanceDto::getCandidateGroups).containsOnly((Object[])new List[]{Collections.emptyList()});
    }

    @Test
    public void importOtherDueDateFormat() {
        String dueDateStringInOtherFormat = "2023-03-02T15:35+02:00";
        ProcessInstanceEvent instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleNativeUserTaskProcess(TEST_PROCESS, "2023-03-02T15:35+02:00"));
        this.waitUntilUserTaskRecordWithElementIdExported("user_task");
        this.removeAllZeebeExportRecordsExceptUserTaskRecords();
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> ((ObjectAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).singleElement()).extracting(FlowNodeInstanceDto::getDueDate).isEqualTo((Object)OffsetDateTime.parse("2023-03-02T15:35+02:00"))});
    }

    private FlowNodeInstanceDto createRunningUserTaskInstance(ProcessInstanceEvent deployedInstance, List<ZeebeUserTaskRecordDto> events) {
        FlowNodeInstanceDto flowNodeInstanceDto = new FlowNodeInstanceDto();
        flowNodeInstanceDto.setFlowNodeInstanceId(String.valueOf(((ZeebeUserTaskDataDto)events.get(0).getValue()).getElementInstanceKey()));
        flowNodeInstanceDto.setFlowNodeId("user_task");
        flowNodeInstanceDto.setFlowNodeType("userTask");
        flowNodeInstanceDto.setProcessInstanceId(String.valueOf(deployedInstance.getProcessInstanceKey()));
        flowNodeInstanceDto.setDefinitionKey(String.valueOf(deployedInstance.getBpmnProcessId()));
        flowNodeInstanceDto.setDefinitionVersion(String.valueOf(deployedInstance.getVersion()));
        flowNodeInstanceDto.setTenantId("<default>");
        flowNodeInstanceDto.setUserTaskInstanceId(String.valueOf(this.getExpectedUserTaskInstanceIdFromRecords(events)));
        flowNodeInstanceDto.setStartDate(this.getExpectedStartDateForUserTaskEvents(events));
        flowNodeInstanceDto.setCanceled(Boolean.valueOf(false));
        return flowNodeInstanceDto;
    }

    private OffsetDateTime getExpectedStartDateForUserTaskEvents(List<ZeebeUserTaskRecordDto> eventsForElement) {
        return this.getTimestampForFirstZeebeEventsWithIntent(eventsForElement, (Intent)UserTaskIntent.CREATING);
    }

    private OffsetDateTime getExpectedEndDateForCompletedUserTaskEvents(List<ZeebeUserTaskRecordDto> eventsForElement) {
        return this.getTimestampForFirstZeebeEventsWithIntent(eventsForElement, (Intent)UserTaskIntent.COMPLETED);
    }

    private OffsetDateTime getTimestampForAssignedUserTaskEvents(List<ZeebeUserTaskRecordDto> eventsForElement) {
        return this.getTimestampForFirstZeebeEventsWithIntent(eventsForElement, (Intent)UserTaskIntent.ASSIGNED);
    }

    private OffsetDateTime getExpectedEndDateForCanceledUserTaskEvents(List<ZeebeUserTaskRecordDto> eventsForElement) {
        return this.getTimestampForFirstZeebeEventsWithIntent(eventsForElement, (Intent)UserTaskIntent.CANCELED);
    }

    private long getExpectedTotalDurationForCompletedUserTask(List<ZeebeUserTaskRecordDto> eventsForElement) {
        return Duration.between(this.getExpectedStartDateForUserTaskEvents(eventsForElement), this.getExpectedEndDateForCompletedUserTaskEvents(eventsForElement)).toMillis();
    }

    private long getDurationInMsBetweenStartAndFirstAssignOperation(List<ZeebeUserTaskRecordDto> eventsForElement) {
        return Duration.between(this.getExpectedStartDateForUserTaskEvents(eventsForElement), this.getTimestampForAssignedUserTaskEvents(eventsForElement)).toMillis();
    }

    private long getDurationInMsBetweenStartDateAndLastAssignedOperation(List<ZeebeUserTaskRecordDto> eventsForElement) {
        return Duration.between(this.getExpectedStartDateForUserTaskEvents(eventsForElement), this.getTimestampForLastZeebeEventsWithIntent(eventsForElement, (Intent)UserTaskIntent.ASSIGNED)).toMillis();
    }

    private long getDurationInMsBetweenAssignOperations(List<ZeebeUserTaskRecordDto> eventsForElement, String assigneeId1, String assigneeId2) {
        return Duration.between(this.getTimestampForZeebeAssignEvents(eventsForElement, assigneeId1), this.getTimestampForZeebeAssignEvents(eventsForElement, assigneeId2)).toMillis();
    }

    private long getDurationInMsBetweenLastAssignOperationAndEnd(List<ZeebeUserTaskRecordDto> eventsForElement, String assigneeId) {
        return Duration.between(this.getTimestampForZeebeAssignEvents(eventsForElement, assigneeId), this.getExpectedEndDateForCompletedUserTaskEvents(eventsForElement)).toMillis();
    }

    private long getExpectedUserTaskInstanceIdFromRecords(List<ZeebeUserTaskRecordDto> eventsForElement) {
        return eventsForElement.stream().findFirst().map(ZeebeRecordDto::getValue).map(ZeebeUserTaskDataDto::getUserTaskKey).orElseThrow(this.eventNotFoundExceptionSupplier);
    }

    private String getExpectedIdFromRecords(List<ZeebeUserTaskRecordDto> eventsForElement, UserTaskIntent intent) {
        return eventsForElement.stream().filter(event -> intent.equals((Object)event.getIntent())).findFirst().map(ZeebeRecordDto::getKey).map(String::valueOf).orElseThrow(this.eventNotFoundExceptionSupplier);
    }

    private String getExpectedIdFromAssignRecordsWithAssigneeId(List<ZeebeUserTaskRecordDto> eventsForElement, String assigneeId) {
        return eventsForElement.stream().filter(event -> UserTaskIntent.ASSIGNED.equals((Object)event.getIntent()) && assigneeId.equals(((ZeebeUserTaskDataDto)event.getValue()).getAssignee())).findFirst().map(ZeebeRecordDto::getKey).map(String::valueOf).orElseThrow(this.eventNotFoundExceptionSupplier);
    }

    private void removeAllZeebeExportRecordsExceptUserTaskRecords() {
        databaseIntegrationTestExtension.deleteAllOtherZeebeRecordsWithPrefix(zeebeExtension.getZeebeRecordPrefix(), "user-task");
    }

    private List<ZeebeUserTaskRecordDto> getZeebeExportedUserTaskEvents() {
        return this.getZeebeExportedUserTaskEventsByElementId().get("user_task");
    }

    private AssigneeOperationDto createAssigneeOperationDto(String id, UserTaskIdentityOperationType userTaskIdentityOperationType, String userId, OffsetDateTime timestamp) {
        AssigneeOperationDto assigneeOperationDto = new AssigneeOperationDto();
        assigneeOperationDto.setId(id);
        assigneeOperationDto.setOperationType(userTaskIdentityOperationType.toString());
        assigneeOperationDto.setUserId(userId);
        assigneeOperationDto.setTimestamp(timestamp);
        return assigneeOperationDto;
    }
}

