/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.identity;

import io.camunda.optimize.dto.optimize.cloud.CloudUserDto;
import io.camunda.optimize.rest.cloud.AccountsUserAccessTokenProvider;
import io.camunda.optimize.rest.cloud.CCSaaSUserCache;
import io.camunda.optimize.rest.cloud.CCSaaSUserClient;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class CCSaaSUserCacheTest {
    public static final String ACCESS_TOKEN = "someToken";
    @Mock
    CCSaaSUserClient ccSaaSUserClient;
    @Mock
    AccountsUserAccessTokenProvider accessTokenProvider;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    ConfigurationService configurationService;
    private CCSaaSUserCache underTest;

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.configurationService.getCaches().getCloudUsers().getMaxSize()).thenReturn((Object)10000);
        Mockito.when((Object)this.accessTokenProvider.getCurrentUsersAccessToken()).thenReturn(Optional.of(ACCESS_TOKEN));
        this.underTest = new CCSaaSUserCache(this.ccSaaSUserClient, this.accessTokenProvider, this.configurationService);
    }

    @Test
    public void testCloudUserCacheIsUsedIfMostRecentRequestWasMoreRecentThanConfiguredInterval() {
        Mockito.when((Object)this.configurationService.getCaches().getCloudUsers().getMinFetchIntervalSeconds()).thenReturn((Object)600L);
        CloudUserDto cloudUserDto = this.createCloudUserWithId("userId");
        Mockito.when((Object)this.ccSaaSUserClient.fetchAllCloudUsers((String)ArgumentMatchers.any())).thenReturn(List.of(cloudUserDto));
        Collection allUsers = this.underTest.getAllUsers();
        Assertions.assertThat((Collection)allUsers).containsExactly((Object[])new CloudUserDto[]{cloudUserDto});
        ((CCSaaSUserClient)Mockito.verify((Object)this.ccSaaSUserClient, (VerificationMode)Mockito.times((int)1))).fetchAllCloudUsers(ACCESS_TOKEN);
        allUsers = this.underTest.getAllUsers();
        Assertions.assertThat((Collection)allUsers).containsExactly((Object[])new CloudUserDto[]{cloudUserDto});
        ((CCSaaSUserClient)Mockito.verify((Object)this.ccSaaSUserClient, (VerificationMode)Mockito.times((int)1))).fetchAllCloudUsers(ACCESS_TOKEN);
    }

    @Test
    public void testCloudUserCacheIsInvalidatedWhenRenewed() {
        Mockito.when((Object)this.configurationService.getCaches().getCloudUsers().getMinFetchIntervalSeconds()).thenReturn((Object)600L);
        CloudUserDto cloudUserDto = this.createCloudUserWithId("userId");
        Mockito.when((Object)this.ccSaaSUserClient.fetchAllCloudUsers((String)ArgumentMatchers.any())).thenReturn(List.of(cloudUserDto));
        Collection allUsers = this.underTest.getAllUsers();
        Assertions.assertThat((Collection)allUsers).containsExactly((Object[])new CloudUserDto[]{cloudUserDto});
        ((CCSaaSUserClient)Mockito.verify((Object)this.ccSaaSUserClient, (VerificationMode)Mockito.times((int)1))).fetchAllCloudUsers(ACCESS_TOKEN);
        Mockito.when((Object)this.configurationService.getCaches().getCloudUsers().getMinFetchIntervalSeconds()).thenReturn((Object)-1L);
        Mockito.when((Object)this.ccSaaSUserClient.fetchAllCloudUsers((String)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        allUsers = this.underTest.getAllUsers();
        Assertions.assertThat((Collection)allUsers).isEmpty();
        ((CCSaaSUserClient)Mockito.verify((Object)this.ccSaaSUserClient, (VerificationMode)Mockito.times((int)2))).fetchAllCloudUsers(ACCESS_TOKEN);
    }

    @Test
    public void testCloudUserCacheIsUsedWhenFetchingIndividualUser() {
        Mockito.when((Object)this.configurationService.getCaches().getCloudUsers().getMinFetchIntervalSeconds()).thenReturn((Object)600L);
        String userId = "userId";
        CloudUserDto cloudUserDto = this.createCloudUserWithId("userId");
        Mockito.when((Object)this.ccSaaSUserClient.fetchAllCloudUsers(ACCESS_TOKEN)).thenReturn(List.of(cloudUserDto));
        this.underTest.getAllUsers();
        Optional fetchedCloudUser = this.underTest.getUserById("userId");
        ((OptionalAssert)Assertions.assertThat((Optional)fetchedCloudUser).isPresent()).get().extracting(user -> user).isEqualTo((Object)cloudUserDto);
        ((CCSaaSUserClient)Mockito.verify((Object)this.ccSaaSUserClient, (VerificationMode)Mockito.times((int)0))).getCloudUserById("userId", ACCESS_TOKEN);
        String otherUserId = "someOtherId";
        CloudUserDto otherCloudUser = this.createCloudUserWithId("someOtherId");
        Mockito.when((Object)this.ccSaaSUserClient.getCloudUserById("someOtherId", ACCESS_TOKEN)).thenReturn(Optional.of(otherCloudUser));
        fetchedCloudUser = this.underTest.getUserById("someOtherId");
        ((OptionalAssert)Assertions.assertThat((Optional)fetchedCloudUser).isPresent()).get().extracting(user -> user).isEqualTo((Object)otherCloudUser);
        ((CCSaaSUserClient)Mockito.verify((Object)this.ccSaaSUserClient, (VerificationMode)Mockito.times((int)1))).getCloudUserById("someOtherId", ACCESS_TOKEN);
    }

    private CloudUserDto createCloudUserWithId(String userId) {
        CloudUserDto cloudUserDto = new CloudUserDto();
        cloudUserDto.setUserId(userId);
        cloudUserDto.setName("User Name");
        cloudUserDto.setEmail("some_email@camunda.com");
        cloudUserDto.setRoles(Collections.emptyList());
        return cloudUserDto;
    }
}

