/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.result.process;

import com.google.common.collect.Lists;
import io.camunda.optimize.dto.optimize.query.report.CombinedReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.SingleReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.ViewProperty;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.MeasureDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.hyper.MapResultEntryDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.report.result.MapCommandResult;
import io.camunda.optimize.service.db.report.result.NumberCommandResult;
import io.camunda.optimize.service.export.CSVUtils;
import io.camunda.optimize.service.util.ProcessReportDataType;
import io.camunda.optimize.service.util.TemplatedProcessReportDataBuilder;
import io.camunda.optimize.test.util.DurationAggregationUtil;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CombinedProcessReportResultTest {
    private static AggregationDto[] getAggregationTypes() {
        return DurationAggregationUtil.getSupportedAggregationTypes();
    }

    @Test
    public void testGetResultAsCsvForMapResult() {
        ProcessReportDataDto processReportDataDto = this.createProcessReportDataForType(ProcessReportDataType.PROC_INST_FREQ_GROUP_BY_VARIABLE);
        ArrayList<MapResultEntryDto> resultDtoMap = new ArrayList<MapResultEntryDto>();
        resultDtoMap.add(new MapResultEntryDto("900.0", Double.valueOf(1.0)));
        resultDtoMap.add(new MapResultEntryDto("10.99", Double.valueOf(1.0)));
        ArrayList mapResults = Lists.newArrayList((Object[])new MapCommandResult[]{new MapCommandResult(Collections.singletonList(MeasureDto.of((ViewProperty)((ViewProperty)processReportDataDto.getViewProperties().get(0)), resultDtoMap)), (SingleReportDataDto)processReportDataDto), new MapCommandResult(Collections.singletonList(MeasureDto.of((ViewProperty)((ViewProperty)processReportDataDto.getViewProperties().get(0)), resultDtoMap)), (SingleReportDataDto)processReportDataDto)});
        CombinedReportEvaluationResult underTest = this.createTestCombinedProcessReportResult(mapResults);
        List resultAsCsv = underTest.getResultAsCsv(Integer.valueOf(10), Integer.valueOf(0), ZoneId.systemDefault());
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(0))).isEqualTo((Object)new String[]{"SingleTestReport0", "", "", "SingleTestReport1", ""});
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(1))).isEqualTo((Object)new String[]{"variable_test_DOUBLE", "processInstance_frequency", "", "variable_test_DOUBLE", "processInstance_frequency"});
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(2))).isEqualTo((Object)new String[]{"10.99", "1.0", "", "10.99", "1.0"});
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(3))).isEqualTo((Object)new String[]{"900.0", "1.0", "", "900.0", "1.0"});
        resultAsCsv = underTest.getResultAsCsv(Integer.valueOf(0), Integer.valueOf(0), ZoneId.systemDefault());
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(0))).isEqualTo((Object)new String[]{"SingleTestReport0", "", "", "SingleTestReport1", ""});
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(1))).isEqualTo((Object)new String[]{"variable_test_DOUBLE", "processInstance_frequency", "", "variable_test_DOUBLE", "processInstance_frequency"});
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(2))).isEqualTo((Object)new String[]{"10.99", "1.0", "", "10.99", "1.0"});
        resultAsCsv = underTest.getResultAsCsv(Integer.valueOf(0), Integer.valueOf(1), ZoneId.systemDefault());
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(0))).isEqualTo((Object)new String[]{"SingleTestReport0", "", "", "SingleTestReport1", ""});
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(1))).isEqualTo((Object)new String[]{"variable_test_DOUBLE", "processInstance_frequency", "", "variable_test_DOUBLE", "processInstance_frequency"});
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(2))).isEqualTo((Object)new String[]{"900.0", "1.0", "", "900.0", "1.0"});
    }

    @Test
    public void testGetResultAsCsvForNumberResult() {
        ProcessReportDataDto processReportDataDto = this.createProcessReportDataForType(ProcessReportDataType.PROC_INST_FREQ_GROUP_BY_NONE);
        ArrayList numberResults = Lists.newArrayList((Object[])new NumberCommandResult[]{new NumberCommandResult(Collections.singletonList(MeasureDto.of((ViewProperty)((ViewProperty)processReportDataDto.getViewProperties().get(0)), (Object)5.0)), (SingleReportDataDto)processReportDataDto), new NumberCommandResult(Collections.singletonList(MeasureDto.of((ViewProperty)((ViewProperty)processReportDataDto.getViewProperties().get(0)), (Object)2.0)), (SingleReportDataDto)processReportDataDto)});
        CombinedReportEvaluationResult underTest = this.createTestCombinedProcessReportResult(numberResults);
        List resultAsCsv = underTest.getResultAsCsv(Integer.valueOf(10), Integer.valueOf(0), ZoneId.systemDefault());
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(0))).isEqualTo((Object)new String[]{"SingleTestReport0", "", "SingleTestReport1"});
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(1))).isEqualTo((Object)new String[]{"processInstance_frequency", "", "processInstance_frequency"});
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(2))).isEqualTo((Object)new String[]{"5.0", "", "2.0"});
    }

    @ParameterizedTest
    @MethodSource(value={"getAggregationTypes"})
    public void testGetResultAsCsvForDurationNumberResult(AggregationDto aggregationType) {
        ProcessReportDataDto processReportDataDto = this.createProcessReportDataForType(ProcessReportDataType.PROC_INST_DUR_GROUP_BY_NONE);
        processReportDataDto.getConfiguration().setAggregationTypes(new AggregationDto[]{aggregationType});
        List<NumberCommandResult> numberResults = List.of(new NumberCommandResult(Collections.singletonList(MeasureDto.of((ViewProperty)((ViewProperty)processReportDataDto.getViewProperties().get(0)), (Object)6.0)), (SingleReportDataDto)processReportDataDto), new NumberCommandResult(Collections.singletonList(MeasureDto.of((ViewProperty)((ViewProperty)processReportDataDto.getViewProperties().get(0)), (Object)6.0)), (SingleReportDataDto)processReportDataDto));
        CombinedReportEvaluationResult underTest = this.createTestCombinedProcessReportResult(numberResults);
        List resultAsCsv = underTest.getResultAsCsv(Integer.valueOf(10), Integer.valueOf(0), ZoneId.systemDefault());
        this.assertCsvByAggregationType(resultAsCsv, aggregationType);
    }

    private void assertCsvByAggregationType(List<String[]> resultAsCsv, AggregationDto aggregationDto) {
        Assertions.assertThat((Object[])resultAsCsv.get(0)).isEqualTo((Object)new String[]{"SingleTestReport0", "", "SingleTestReport1"});
        Assertions.assertThat((Object[])resultAsCsv.get(1)).isEqualTo((Object)new String[]{"processInstance_duration", "", "processInstance_duration"});
        Assertions.assertThat((Object[])resultAsCsv.get(2)).isEqualTo((Object)new String[]{CSVUtils.mapAggregationType((AggregationDto)aggregationDto), "", CSVUtils.mapAggregationType((AggregationDto)aggregationDto)});
        Assertions.assertThat((Object[])resultAsCsv.get(3)).isEqualTo((Object)new String[]{"6.0", "", "6.0"});
    }

    @ParameterizedTest
    @MethodSource(value={"getAggregationTypes"})
    public void testGetResultAsCsvForDurationMapResult(AggregationDto aggregationType) {
        ProcessReportDataDto processReportDataDto = this.createProcessReportDataForType(ProcessReportDataType.PROC_INST_DUR_GROUP_BY_VARIABLE);
        processReportDataDto.getConfiguration().setAggregationTypes(new AggregationDto[]{aggregationType});
        ArrayList<MapResultEntryDto> resultDtoMap = new ArrayList<MapResultEntryDto>();
        resultDtoMap.add(new MapResultEntryDto("test1", Double.valueOf(3.0)));
        resultDtoMap.add(new MapResultEntryDto("test2", Double.valueOf(6.0)));
        ArrayList mapResults = Lists.newArrayList((Object[])new MapCommandResult[]{new MapCommandResult(Collections.singletonList(MeasureDto.of((ViewProperty)((ViewProperty)processReportDataDto.getViewProperties().get(0)), resultDtoMap)), (SingleReportDataDto)processReportDataDto), new MapCommandResult(Collections.singletonList(MeasureDto.of((ViewProperty)((ViewProperty)processReportDataDto.getViewProperties().get(0)), resultDtoMap)), (SingleReportDataDto)processReportDataDto)});
        CombinedReportEvaluationResult underTest = this.createTestCombinedProcessReportResult(mapResults);
        List resultAsCsv = underTest.getResultAsCsv(Integer.valueOf(10), Integer.valueOf(0), ZoneId.systemDefault());
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(0))).isEqualTo((Object)new String[]{"SingleTestReport0", "", "", "SingleTestReport1", ""});
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(1))).isEqualTo((Object)new String[]{"variable_test_DOUBLE", "processInstance_duration", "", "variable_test_DOUBLE", "processInstance_duration"});
        Assertions.assertThat((Object[])new String[]{"", CSVUtils.mapAggregationType((AggregationDto)aggregationType), "", "", CSVUtils.mapAggregationType((AggregationDto)aggregationType)}).isEqualTo(resultAsCsv.get(2));
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(3))).isEqualTo((Object)new String[]{"test1", "3.0", "", "test1", "3.0"});
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(4))).isEqualTo((Object)new String[]{"test2", "6.0", "", "test2", "6.0"});
        resultAsCsv = underTest.getResultAsCsv(Integer.valueOf(0), Integer.valueOf(0), ZoneId.systemDefault());
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(0))).isEqualTo((Object)new String[]{"SingleTestReport0", "", "", "SingleTestReport1", ""});
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(1))).isEqualTo((Object)new String[]{"variable_test_DOUBLE", "processInstance_duration", "", "variable_test_DOUBLE", "processInstance_duration"});
        Assertions.assertThat((Object[])new String[]{"", CSVUtils.mapAggregationType((AggregationDto)aggregationType), "", "", CSVUtils.mapAggregationType((AggregationDto)aggregationType)}).isEqualTo(resultAsCsv.get(2));
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(3))).isEqualTo((Object)new String[]{"test1", "3.0", "", "test1", "3.0"});
        resultAsCsv = underTest.getResultAsCsv(Integer.valueOf(0), Integer.valueOf(1), ZoneId.systemDefault());
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(0))).isEqualTo((Object)new String[]{"SingleTestReport0", "", "", "SingleTestReport1", ""});
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(1))).isEqualTo((Object)new String[]{"variable_test_DOUBLE", "processInstance_duration", "", "variable_test_DOUBLE", "processInstance_duration"});
        Assertions.assertThat((Object[])new String[]{"", CSVUtils.mapAggregationType((AggregationDto)aggregationType), "", "", CSVUtils.mapAggregationType((AggregationDto)aggregationType)}).isEqualTo(resultAsCsv.get(2));
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(3))).isEqualTo((Object)new String[]{"test2", "6.0", "", "test2", "6.0"});
    }

    @Test
    public void testGetResultAsCsvForEmptyReport() {
        CombinedReportEvaluationResult underTest = new CombinedReportEvaluationResult(Collections.emptyList(), 0L, new CombinedReportDefinitionRequestDto());
        List resultAsCsv = underTest.getResultAsCsv(Integer.valueOf(10), Integer.valueOf(0), ZoneId.systemDefault());
        Assertions.assertThat((Object[])((String[])resultAsCsv.get(0))).isEqualTo((Object)new String[0]);
    }

    private <T> CombinedReportEvaluationResult createTestCombinedProcessReportResult(List<? extends CommandEvaluationResult<T>> reportCommandResults) {
        ArrayList reportEvaluationResults = new ArrayList();
        for (int i = 0; i < reportCommandResults.size(); ++i) {
            CommandEvaluationResult<T> commandEvaluationResult = reportCommandResults.get(i);
            SingleProcessReportDefinitionRequestDto reportDefinition = new SingleProcessReportDefinitionRequestDto();
            reportDefinition.setName("SingleTestReport" + i);
            reportDefinition.setData((ReportDataDto)((ProcessReportDataDto)commandEvaluationResult.getReportDataAs(ProcessReportDataDto.class)));
            reportEvaluationResults.add(new SingleReportEvaluationResult((ReportDefinitionDto)reportDefinition, Collections.singletonList(commandEvaluationResult)));
        }
        return this.createCombinedProcessReportResult(reportEvaluationResults);
    }

    private ProcessReportDataDto createProcessReportDataForType(ProcessReportDataType reportDataType) {
        return TemplatedProcessReportDataBuilder.createReportData().setVariableName("test").setReportDataType(reportDataType).setVariableType(VariableType.DOUBLE).build();
    }

    private CombinedReportEvaluationResult createCombinedProcessReportResult(List<SingleReportEvaluationResult<?>> singleReportResults) {
        return new CombinedReportEvaluationResult(singleReportResults, 0L, new CombinedReportDefinitionRequestDto());
    }
}

