/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.MetricEnum;
import io.camunda.optimize.OptimizeObjectMapperContextResolver;
import io.camunda.optimize.dto.optimize.query.security.CredentialsRequestDto;
import io.camunda.optimize.exception.OptimizeIntegrationTestException;
import io.camunda.optimize.service.security.AuthCookieService;
import io.camunda.optimize.service.util.mapper.ObjectMapperFactory;
import io.camunda.optimize.test.it.extension.IntegrationTestConfigurationUtil;
import io.camunda.optimize.tomcat.OptimizeResourceConstants;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizeRequestExecutor {
    private static final int MAX_LOGGED_BODY_SIZE = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(OptimizeRequestExecutor.class);
    private final WebTarget defaultWebTarget;
    private WebTarget webTarget;
    private final String defaultUser;
    private final String defaultUserPassword;
    private final ObjectMapper objectMapper;
    private final Map<String, String> cookies = new HashMap<String, String>();
    private final Map<String, String> requestHeaders = new HashMap<String, String>();
    private String defaultAuthCookie;
    private String authCookie;
    private String path;
    private String method;
    private Entity<?> body;
    private String mediaType = "application/json";
    private Map<String, Object> queryParams;

    public OptimizeRequestExecutor(String defaultUser, String defaultUserPassword, String restEndpoint) {
        this.defaultUser = defaultUser;
        this.defaultUserPassword = defaultUserPassword;
        this.objectMapper = OptimizeRequestExecutor.getDefaultObjectMapper();
        this.webTarget = this.defaultWebTarget = this.createWebTarget(restEndpoint);
    }

    public OptimizeRequestExecutor setActuatorWebTarget() {
        this.webTarget = this.createActuatorWebTarget();
        return this;
    }

    public OptimizeRequestExecutor initAuthCookie() {
        this.authCookie = this.defaultAuthCookie = this.authenticateUserRequest(this.defaultUser, this.defaultUserPassword);
        return this;
    }

    public OptimizeRequestExecutor addSingleQueryParam(String key, Object value) {
        if (this.queryParams != null && this.queryParams.size() != 0) {
            this.queryParams.put(key, value);
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(key, value);
            this.queryParams = params;
        }
        return this;
    }

    public OptimizeRequestExecutor withoutAuthentication() {
        this.authCookie = null;
        return this;
    }

    public Response execute() {
        Invocation.Builder builder = this.prepareRequest();
        Response response = switch (this.method) {
            case "GET" -> builder.get();
            case "POST" -> builder.post(this.body);
            case "PUT" -> builder.put(this.body);
            case "DELETE" -> builder.delete();
            default -> throw new OptimizeIntegrationTestException("Unsupported http method: " + this.method);
        };
        this.resetBuilder();
        response.bufferEntity();
        return response;
    }

    private Invocation.Builder prepareRequest() {
        WebTarget webTarget = this.webTarget.path(this.path);
        if (this.queryParams != null && this.queryParams.size() != 0) {
            for (Map.Entry<String, Object> queryParam : this.queryParams.entrySet()) {
                if (queryParam.getValue() instanceof List) {
                    for (Object p : (List)queryParam.getValue()) {
                        webTarget = webTarget.queryParam(queryParam.getKey(), new Object[]{Objects.requireNonNullElse(p, "null")});
                    }
                    continue;
                }
                webTarget = webTarget.queryParam(queryParam.getKey(), new Object[]{queryParam.getValue()});
            }
        }
        Invocation.Builder builder = webTarget.request();
        for (Map.Entry<String, String> cookieEntry : this.cookies.entrySet()) {
            builder = builder.cookie(cookieEntry.getKey(), cookieEntry.getValue());
        }
        if (this.defaultAuthCookie == null) {
            this.initAuthCookie();
        }
        if (this.authCookie != null) {
            builder = builder.cookie(AuthCookieService.getAuthorizationCookieNameWithSuffix((int)0), this.authCookie);
        }
        for (Map.Entry<String, String> headerEntry : this.requestHeaders.entrySet()) {
            builder = builder.header(headerEntry.getKey(), (Object)headerEntry.getValue());
        }
        return builder;
    }

    public <T> T execute(Class<T> classToExtractFromResponse, int responseCode) {
        try (Response response = this.execute();){
            this.assertStatusCode(response, responseCode);
            Object object = response.readEntity(classToExtractFromResponse);
            return (T)object;
        }
    }

    private void assertStatusCode(Response response, int expectedStatus) {
        String responseString = (String)response.readEntity(String.class);
        ((AbstractIntegerAssert)Assertions.assertThat((int)response.getStatus()).withFailMessage("Expected status code " + expectedStatus + ", actual status code: " + response.getStatus() + ".\nResponse contains the following message:\n" + responseString, new Object[0])).isEqualTo(expectedStatus);
    }

    private void resetBuilder() {
        this.webTarget = this.defaultWebTarget;
        this.authCookie = this.defaultAuthCookie;
        this.body = null;
        this.path = null;
        this.method = null;
        this.queryParams = null;
        this.mediaType = "application/json";
        this.cookies.clear();
        this.requestHeaders.clear();
    }

    public OptimizeRequestExecutor buildGetReadinessRequest() {
        this.path = "/readyz";
        this.method = "GET";
        return this;
    }

    public OptimizeRequestExecutor buildIndexingTimeMetricRequest() {
        this.path = "metrics/" + MetricEnum.INDEXING_DURATION_METRIC.getName();
        this.method = "GET";
        this.mediaType = "application/json";
        return this;
    }

    public OptimizeRequestExecutor buildPageFetchTimeMetricRequest() {
        this.path = "metrics/" + MetricEnum.NEW_PAGE_FETCH_TIME_METRIC.getName();
        this.method = "GET";
        this.mediaType = "application/json";
        return this;
    }

    public OptimizeRequestExecutor buildOverallImportTimeMetricRequest() {
        this.path = "metrics/" + MetricEnum.OVERALL_IMPORT_TIME_METRIC.getName();
        this.method = "GET";
        this.mediaType = "application/json";
        return this;
    }

    private String authenticateUserRequest(String username, String password) {
        CredentialsRequestDto entity = new CredentialsRequestDto(username, password);
        Response response = this.defaultWebTarget.path("authentication").request().post(Entity.json((Object)entity));
        return AuthCookieService.createOptimizeAuthCookieValue((String)((String)response.readEntity(String.class)));
    }

    private WebTarget createActuatorWebTarget() {
        return this.createWebTarget("http://localhost:" + OptimizeResourceConstants.ACTUATOR_PORT + OptimizeResourceConstants.ACTUATOR_ENDPOINT);
    }

    public WebTarget createWebTarget(String targetUrl) {
        return this.createClient().target(targetUrl);
    }

    private Client createClient() {
        OptimizeObjectMapperContextResolver provider = new OptimizeObjectMapperContextResolver(this.objectMapper);
        Client client = (Client)ClientBuilder.newClient().register((Object)provider);
        client.register(requestContext -> LOG.debug("EmbeddedTestClient request {} {}", (Object)requestContext.getMethod(), (Object)requestContext.getUri()));
        client.register((requestContext, responseContext) -> {
            if (responseContext.hasEntity()) {
                responseContext.setEntityStream(this.wrapEntityStreamIfNecessary(responseContext.getEntityStream()));
            }
            LOG.debug("EmbeddedTestClient response for {} {}: {}", new Object[]{requestContext.getMethod(), requestContext.getUri(), responseContext.hasEntity() ? this.serializeBodyCappedToMaxSize(responseContext.getEntityStream()) : ""});
        });
        client.property("jersey.config.client.connectTimeout", (Object)IntegrationTestConfigurationUtil.getHttpTimeoutMillis());
        client.property("jersey.config.client.readTimeout", (Object)IntegrationTestConfigurationUtil.getHttpTimeoutMillis());
        client.property("jersey.config.client.followRedirects", (Object)Boolean.FALSE);
        this.acceptSelfSignedCertificates(client);
        return client;
    }

    private void acceptSelfSignedCertificates(Client client) {
        try {
            client.getSslContext().init(null, new TrustManager[]{new X509TrustManager(this){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
        }
        catch (KeyManagementException e) {
            throw new OptimizeIntegrationTestException("Was not able to configure jersey client to accept all certificates", e);
        }
    }

    private InputStream wrapEntityStreamIfNecessary(InputStream originalEntityStream) {
        return !originalEntityStream.markSupported() ? new BufferedInputStream(originalEntityStream) : originalEntityStream;
    }

    private String serializeBodyCappedToMaxSize(InputStream entityStream) throws IOException {
        entityStream.mark(10001);
        byte[] entity = new byte[10001];
        int entitySize = entityStream.read(entity);
        StringBuilder stringBuilder = new StringBuilder(new String(entity, 0, Math.min(entitySize, 10000), StandardCharsets.UTF_8));
        if (entitySize > 10000) {
            stringBuilder.append("...");
        }
        stringBuilder.append('\n');
        entityStream.reset();
        return stringBuilder.toString();
    }

    private static ObjectMapper getDefaultObjectMapper() {
        return ObjectMapperFactory.OPTIMIZE_MAPPER;
    }

    public WebTarget getDefaultWebTarget() {
        return this.defaultWebTarget;
    }

    public WebTarget getWebTarget() {
        return this.webTarget;
    }
}

