/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.tomcat;

import io.camunda.optimize.service.util.configuration.ConfigurationService;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

public class ResponseSecurityHeaderFilter
implements Filter {
    private final ConfigurationService configurationService;

    public ResponseSecurityHeaderFilter(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Map headers = this.configurationService.getSecurityConfiguration().getResponseHeaders().getHeadersWithValues();
        for (String key : headers.keySet()) {
            httpResponse.addHeader(key, (String)headers.get(key));
        }
        chain.doFilter(request, response);
    }
}

