/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.tomcat;

import io.camunda.optimize.tomcat.OptimizeResourceConstants;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class NoCachingFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        String requestPath = servletRequest.getServletPath();
        boolean isStaticResourceThatShouldNotBeCached = OptimizeResourceConstants.NO_CACHE_RESOURCES.stream().anyMatch(requestPath::endsWith);
        if (isStaticResourceThatShouldNotBeCached || this.isApiRestCall(requestPath)) {
            ((HttpServletResponse)response).setHeader("Cache-Control", "no-store");
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private boolean isApiRestCall(String requestPath) {
        return requestPath.startsWith("/api");
    }
}

