/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.variable;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.query.variable.DefinitionVariableLabelsDto;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.writer.VariableLabelWriter;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessVariableLabelService {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessVariableLabelService.class);
    private final VariableLabelWriter variableLabelWriter;
    private final DefinitionService definitionService;

    public ProcessVariableLabelService(VariableLabelWriter variableLabelWriter, DefinitionService definitionService) {
        this.variableLabelWriter = variableLabelWriter;
        this.definitionService = definitionService;
    }

    public void storeVariableLabels(DefinitionVariableLabelsDto definitionVariableLabelsDto) {
        definitionVariableLabelsDto.getLabels().stream().collect(Collectors.groupingBy(label -> label.getVariableName() + String.valueOf(label.getVariableType()), Collectors.counting())).values().forEach(count -> {
            if (count > 1L) {
                throw new BadRequestException("Each variable can only have a single label!");
            }
        });
        if (!this.definitionService.definitionExists(DefinitionType.PROCESS, definitionVariableLabelsDto.getDefinitionKey())) {
            throw new NotFoundException("The process definition with id " + definitionVariableLabelsDto.getDefinitionKey() + " has not yet been imported to Optimize");
        }
        this.variableLabelWriter.createVariableLabelUpsertRequest(definitionVariableLabelsDto);
    }

    public void deleteVariableLabelsForDefinition(String processDefinitionKey) {
        this.variableLabelWriter.deleteVariableLabelsForDefinition(processDefinitionKey);
    }
}

