/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.variable;

import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.query.variable.DecisionVariableNameRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.DecisionVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.DecisionVariableValueRequestDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.reader.DecisionVariableReader;
import io.camunda.optimize.service.security.util.tenant.DataSourceTenantAuthorizationService;
import io.camunda.optimize.service.util.ValidationHelper;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DecisionVariableService {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionVariableService.class);
    private final DecisionVariableReader decisionVariableReader;
    private final DataSourceTenantAuthorizationService tenantAuthorizationService;

    public DecisionVariableService(DecisionVariableReader decisionVariableReader, DataSourceTenantAuthorizationService tenantAuthorizationService) {
        this.decisionVariableReader = decisionVariableReader;
        this.tenantAuthorizationService = tenantAuthorizationService;
    }

    public List<DecisionVariableNameResponseDto> getInputVariableNames(List<DecisionVariableNameRequestDto> variableRequestDtos) {
        return variableRequestDtos.stream().flatMap(entry -> this.decisionVariableReader.getInputVariableNames(entry.getDecisionDefinitionKey(), entry.getDecisionDefinitionVersions(), DefinitionService.prepareTenantListForDefinitionSearch(entry.getTenantIds())).stream()).distinct().collect(Collectors.toList());
    }

    public List<DecisionVariableNameResponseDto> getOutputVariableNames(List<DecisionVariableNameRequestDto> variableRequestDtos) {
        return variableRequestDtos.stream().flatMap(entry -> this.decisionVariableReader.getOutputVariableNames(entry.getDecisionDefinitionKey(), entry.getDecisionDefinitionVersions(), DefinitionService.prepareTenantListForDefinitionSearch(entry.getTenantIds())).stream()).distinct().collect(Collectors.toList());
    }

    public List<String> getInputVariableValues(String userId, DecisionVariableValueRequestDto requestDto) {
        ValidationHelper.ensureNotEmpty("decision definition key", requestDto.getDecisionDefinitionKey());
        ValidationHelper.ensureNotEmpty("variable id", requestDto.getVariableId());
        ValidationHelper.ensureNotEmpty("variable type", requestDto.getVariableType());
        if (!this.tenantAuthorizationService.isAuthorizedToSeeAllTenants(userId, IdentityType.USER, requestDto.getTenantIds())) {
            throw new ForbiddenException("Current user is not authorized to access data of all provided tenants");
        }
        return this.decisionVariableReader.getInputVariableValues(requestDto);
    }

    public List<String> getOutputVariableValues(String userId, DecisionVariableValueRequestDto requestDto) {
        ValidationHelper.ensureNotEmpty("decision definition key", requestDto.getDecisionDefinitionKey());
        ValidationHelper.ensureNotEmpty("variable id", requestDto.getVariableId());
        ValidationHelper.ensureNotEmpty("variable type", requestDto.getVariableType());
        if (!this.tenantAuthorizationService.isAuthorizedToSeeAllTenants(userId, IdentityType.USER, requestDto.getTenantIds())) {
            throw new ForbiddenException("Current user is not authorized to access data of all provided tenants");
        }
        return this.decisionVariableReader.getOutputVariableValues(requestDto);
    }
}

