/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicAction {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicAction.class);
    private final ScheduledExecutorService executorService;
    private final String actionName;
    private final Runnable onSchedule;

    public PeriodicAction(String actionName, Runnable onSchedule) {
        this.actionName = actionName;
        this.onSchedule = onSchedule;
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat(actionName + "-progress-%d").build());
    }

    public void start() {
        LOG.debug(String.format("Scheduling periodic action %s", this.actionName));
        this.executorService.scheduleAtFixedRate(this.onSchedule, 0L, 30L, TimeUnit.SECONDS);
    }

    public void stop() {
        try {
            LOG.debug(String.format("Stopping periodic action %s", this.actionName));
            this.executorService.shutdownNow();
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to stop periodic action %s", this.actionName));
        }
    }
}

