/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import com.google.common.collect.ImmutableList;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.schema.index.AbstractInstanceIndex;
import io.camunda.optimize.service.util.DefinitionVersionHandlingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;

public final class DefinitionQueryUtilOS {
    private DefinitionQueryUtilOS() {
    }

    public static Query createDefinitionQuery(String definitionKey, List<String> tenantIds, AbstractInstanceIndex type) {
        return DefinitionQueryUtilOS.createDefinitionQuery(definitionKey, (List<String>)ImmutableList.of((Object)"all"), tenantIds, type, s -> "");
    }

    public static Query createDefinitionQuery(Map<String, Set<String>> definitionKeyToTenantsMap, String definitionKeyFieldName, String tenantKeyFieldName) {
        BoolQuery.Builder query = new BoolQuery.Builder().minimumShouldMatch("1");
        definitionKeyToTenantsMap.forEach((definitionKey, tenantIds) -> query.should(new BoolQuery.Builder().must(QueryDSL.term((String)definitionKeyFieldName, (String)definitionKey), new Query[0]).must(DefinitionQueryUtilOS.createTenantIdQuery(tenantKeyFieldName, new ArrayList<String>((Collection<String>)tenantIds)), new Query[0]).build().toQuery(), new Query[0]));
        return query.build().toQuery();
    }

    public static Query createDefinitionQuery(String definitionKey, List<String> definitionVersions, List<String> tenantIds, AbstractInstanceIndex type, UnaryOperator<String> getLatestVersionToKey) {
        BoolQuery.Builder query = new BoolQuery.Builder();
        query.must(DefinitionQueryUtilOS.createTenantIdQuery(type.getTenantIdFieldName(), tenantIds), new Query[0]);
        query.must(QueryDSL.term((String)type.getDefinitionKeyFieldName(), (String)definitionKey), new Query[0]);
        if (DefinitionVersionHandlingUtil.isDefinitionVersionSetToLatest(definitionVersions)) {
            query.must(QueryDSL.term((String)type.getDefinitionVersionFieldName(), (String)((String)getLatestVersionToKey.apply(definitionKey))), new Query[0]);
        } else if (!DefinitionVersionHandlingUtil.isDefinitionVersionSetToAll(definitionVersions)) {
            query.must(QueryDSL.stringTerms((String)type.getDefinitionVersionFieldName(), definitionVersions), new Query[0]);
        } else if (definitionVersions.isEmpty()) {
            query.mustNot(QueryDSL.matchAll(), new Query[0]);
        }
        return query.build().toQuery();
    }

    public static Query createTenantIdQuery(String tenantField, List<String> tenantIds) {
        AtomicBoolean includeNotDefinedTenant = new AtomicBoolean(false);
        List tenantIdTerms = tenantIds.stream().peek(id -> {
            if (id == null) {
                includeNotDefinedTenant.set(true);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        BoolQuery.Builder tenantQueryBuilder = new BoolQuery.Builder().minimumShouldMatch("1");
        if (!tenantIdTerms.isEmpty()) {
            tenantQueryBuilder.should(QueryDSL.stringTerms((String)tenantField, tenantIdTerms), new Query[0]);
        }
        if (includeNotDefinedTenant.get()) {
            tenantQueryBuilder.should(new BoolQuery.Builder().mustNot(QueryDSL.exists((String)tenantField), new Query[0]).build().toQuery(), new Query[0]);
        }
        if (tenantIdTerms.isEmpty() && !includeNotDefinedTenant.get()) {
            tenantQueryBuilder.mustNot(QueryDSL.matchAll(), new Query[0]);
        }
        return tenantQueryBuilder.build().toQuery();
    }
}

