/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class DecisionVariableHelper {
    private static final List<VariableType> MULTIVALUE_TYPE_FIELDS = Collections.unmodifiableList(Arrays.asList(VariableType.DATE, VariableType.DOUBLE, VariableType.LONG));

    private DecisionVariableHelper() {
    }

    public static String getVariableValueField(String variablePath) {
        return variablePath + ".value";
    }

    public static List<VariableType> getVariableMultivalueFields() {
        return MULTIVALUE_TYPE_FIELDS;
    }

    public static String getVariableStringValueField(String variablePath) {
        return DecisionVariableHelper.getVariableValueFieldForType(variablePath, VariableType.STRING);
    }

    public static String getValueSearchField(String variablePath, String searchFieldName) {
        return DecisionVariableHelper.getVariableStringValueField(variablePath) + "." + searchFieldName;
    }

    public static String buildWildcardQuery(String valueFilter) {
        return "*" + valueFilter + "*";
    }

    public static String getVariableValueFieldForType(String variablePath, VariableType type) {
        return switch (Optional.ofNullable(type).orElseThrow(() -> new IllegalArgumentException("No Type provided"))) {
            case VariableType.BOOLEAN, VariableType.STRING, VariableType.OBJECT -> DecisionVariableHelper.getVariableValueField(variablePath);
            case VariableType.DOUBLE -> DecisionVariableHelper.getVariableValueField(variablePath) + ".double";
            case VariableType.SHORT, VariableType.INTEGER, VariableType.LONG -> DecisionVariableHelper.getVariableValueField(variablePath) + ".long";
            case VariableType.DATE -> DecisionVariableHelper.getVariableValueField(variablePath) + ".date";
            default -> throw new IllegalArgumentException("Unhandled type: " + String.valueOf(type));
        };
    }

    public static String getVariableClauseIdField(String variablePath) {
        return variablePath + ".clauseId";
    }

    public static String getVariableTypeField(String variablePath) {
        return variablePath + ".type";
    }
}

