/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.status;

import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.status.StatusCheckingService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import org.opensearch.client.opensearch._types.HealthStatus;
import org.opensearch.client.opensearch.cluster.HealthRequest;
import org.opensearch.client.opensearch.cluster.HealthResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class StatusCheckingServiceOS
extends StatusCheckingService {
    private final OptimizeOpenSearchClient osClient;

    public StatusCheckingServiceOS(OptimizeOpenSearchClient osClient, OptimizeIndexNameService optimizeIndexNameService) {
        super(optimizeIndexNameService);
        this.osClient = osClient;
    }

    @Override
    public boolean isConnectedToDatabase() {
        try {
            HealthResponse clusterHealthResponse = this.osClient.getOpenSearchClient().cluster().health(new HealthRequest.Builder().build());
            return clusterHealthResponse.status() != HealthStatus.Red;
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

