/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.security.authentication;

import io.camunda.identity.sdk.authentication.AccessToken;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.authentication.dto.AuthCodeDto;
import io.camunda.identity.sdk.exception.IdentityException;
import io.camunda.optimize.dto.optimize.query.security.CredentialsRequestDto;
import io.camunda.optimize.rest.exceptions.NotAuthorizedException;
import io.camunda.optimize.rest.exceptions.NotSupportedException;
import io.camunda.optimize.service.security.AuthCookieService;
import io.camunda.optimize.service.security.CCSMTokenService;
import io.camunda.optimize.service.security.SessionService;
import io.camunda.optimize.service.security.authentication.AbstractAuthenticationService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSMCondition;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSMCondition.class})
public class CCSMAuthenticationService
extends AbstractAuthenticationService {
    private static final Logger LOG = LoggerFactory.getLogger(CCSMAuthenticationService.class);
    private final ConfigurationService configurationService;
    private final CCSMTokenService ccsmTokenService;

    public CCSMAuthenticationService(SessionService sessionService, AuthCookieService authCookieService, CCSMTokenService ccsmTokenService, ConfigurationService configurationService) {
        super(sessionService, authCookieService);
        this.configurationService = configurationService;
        this.ccsmTokenService = ccsmTokenService;
    }

    @Override
    public void authenticateUser(CredentialsRequestDto credentials) {
        throw new NotSupportedException("Requests to this endpoint are not valid in Camunda Platform Self-Managed mode");
    }

    @Override
    public void loginCallback(AuthCodeDto authCode, URI uri, HttpServletResponse response) throws IOException {
        AccessToken accessToken;
        Tokens tokens;
        try {
            tokens = this.ccsmTokenService.exchangeAuthCode(authCode, uri);
            accessToken = this.ccsmTokenService.verifyToken(tokens.getAccessToken());
        }
        catch (NotAuthorizedException ex) {
            response.sendError(HttpStatus.FORBIDDEN.value(), "User has no authorization to access Optimize. Please check your Identity configuration");
            return;
        }
        this.ccsmTokenService.createOptimizeAuthNewCookies(tokens, accessToken, uri.getScheme()).forEach(arg_0 -> ((HttpServletResponse)response).addCookie(arg_0));
        response.sendRedirect(this.buildRootRedirect(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout(Cookie[] cookies, HttpServletResponse response) {
        if (cookies != null) {
            try {
                Arrays.stream(cookies).filter(cookie -> cookie.getName().equals("X-Optimize-Refresh-Token")).forEach(refreshCookie -> this.ccsmTokenService.revokeToken(refreshCookie.getValue()));
            }
            catch (IdentityException identityException) {
            }
            finally {
                this.ccsmTokenService.createOptimizeDeleteAuthNewCookies().forEach(arg_0 -> ((HttpServletResponse)response).addCookie(arg_0));
            }
        }
    }

    private String buildRootRedirect(URI uri) {
        Object redirectUri;
        String configuredRedirectRootUrl = this.configurationService.getAuthConfiguration().getCcsmAuthConfiguration().getRedirectRootUrl();
        if (!StringUtils.isEmpty((CharSequence)configuredRedirectRootUrl)) {
            redirectUri = configuredRedirectRootUrl;
        } else {
            redirectUri = uri.getScheme() + "://" + uri.getHost();
            if (uri.getPort() != -1) {
                redirectUri = (String)redirectUri + ":" + uri.getPort();
            }
            redirectUri = (String)redirectUri + this.configurationService.getContextPath().orElse("/");
        }
        String targetUri = redirectUri;
        redirectUri = (String)redirectUri + "static/redirect.html?url=" + targetUri;
        LOG.trace("Using root redirect Url: {}", redirectUri);
        return redirectUri;
    }
}

