/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.security;

import io.camunda.optimize.dto.optimize.query.TerminatedUserSessionDto;
import io.camunda.optimize.service.AbstractScheduledService;
import io.camunda.optimize.service.db.reader.TerminatedUserSessionReader;
import io.camunda.optimize.service.db.writer.TerminatedUserSessionWriter;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.stereotype.Component;

@Component
public class TerminatedSessionService
extends AbstractScheduledService {
    private static final int CLEANUP_INTERVAL_HOURS = 8;
    private static final Logger LOG = LoggerFactory.getLogger(TerminatedSessionService.class);
    private final TerminatedUserSessionReader terminatedUserSessionReader;
    private final TerminatedUserSessionWriter terminatedUserSessionWriter;
    private final ConfigurationService configurationService;

    public TerminatedSessionService(TerminatedUserSessionReader terminatedUserSessionReader, TerminatedUserSessionWriter terminatedUserSessionWriter, ConfigurationService configurationService) {
        this.terminatedUserSessionReader = terminatedUserSessionReader;
        this.terminatedUserSessionWriter = terminatedUserSessionWriter;
        this.configurationService = configurationService;
    }

    @PostConstruct
    public void initScheduledCleanup() {
        this.startScheduling();
    }

    @PreDestroy
    public void stopScheduledCleanup() {
        this.stopScheduling();
    }

    @Override
    protected void run() {
        this.cleanup();
    }

    @Override
    protected Trigger createScheduleTrigger() {
        return new PeriodicTrigger(Duration.ofHours(8L));
    }

    public void terminateUserSession(String sessionId) {
        TerminatedUserSessionDto sessionDto = new TerminatedUserSessionDto(sessionId);
        this.terminatedUserSessionWriter.writeTerminatedUserSession(sessionDto);
    }

    public boolean isSessionTerminated(String sessionId) {
        return this.terminatedUserSessionReader.exists(sessionId);
    }

    public void cleanup() {
        LOG.debug("Cleaning up terminated user sessions.");
        this.terminatedUserSessionWriter.deleteTerminatedUserSessionsOlderThan(LocalDateUtil.getCurrentDateTime().minus(this.configurationService.getAuthConfiguration().getTokenLifeTimeMinutes(), ChronoUnit.MINUTES));
    }
}

