/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.security;

import com.auth0.jwt.interfaces.DecodedJWT;
import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.authentication.AccessToken;
import io.camunda.identity.sdk.authentication.Authentication;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.authentication.UserDetails;
import io.camunda.identity.sdk.authentication.dto.AuthCodeDto;
import io.camunda.identity.sdk.authentication.exception.CodeExchangeException;
import io.camunda.identity.sdk.authentication.exception.TokenDecodeException;
import io.camunda.identity.sdk.authentication.exception.TokenVerificationException;
import io.camunda.identity.sdk.exception.IdentityException;
import io.camunda.identity.sdk.impl.rest.exception.RestException;
import io.camunda.optimize.dto.optimize.TenantDto;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.rest.exceptions.NotAuthorizedException;
import io.camunda.optimize.service.security.AuthCookieService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSMCondition;
import jakarta.servlet.http.Cookie;
import java.net.URI;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Conditional(value={CCSMCondition.class})
public class CCSMTokenService {
    private static final String OPTIMIZE_PERMISSION = "write:*";
    private static final Logger LOG = LoggerFactory.getLogger(CCSMTokenService.class);
    private final AuthCookieService authCookieService;
    private final ConfigurationService configurationService;
    private final Identity identity;

    public CCSMTokenService(AuthCookieService authCookieService, ConfigurationService configurationService, Identity identity) {
        this.authCookieService = authCookieService;
        this.configurationService = configurationService;
        this.identity = identity;
    }

    public List<Cookie> createOptimizeAuthCookies(Tokens tokens, AccessToken accessToken, String scheme) {
        Cookie optimizeAuthCookie = this.authCookieService.createCookie("X-Optimize-Authorization", accessToken.getToken().getToken(), accessToken.getToken().getExpiresAtAsInstant(), scheme);
        Date refreshTokenExpirationDate = this.getRefreshTokenExpirationDate(tokens.getRefreshToken());
        Cookie optimizeRefreshCookie = this.authCookieService.createCookie("X-Optimize-Refresh-Token", tokens.getRefreshToken(), (Instant)Optional.ofNullable(refreshTokenExpirationDate).map(Date::toInstant).orElse(null), scheme);
        return List.of(optimizeAuthCookie, optimizeRefreshCookie);
    }

    public List<Cookie> createOptimizeAuthNewCookies(Tokens tokens, AccessToken accessToken, String scheme) {
        Cookie optimizeAuthCookie = this.authCookieService.createCookie("X-Optimize-Authorization", accessToken.getToken().getToken(), accessToken.getToken().getExpiresAt(), scheme);
        Cookie optimizeRefreshCookie = this.authCookieService.createCookie("X-Optimize-Refresh-Token", tokens.getRefreshToken(), this.getRefreshTokenExpirationDate(tokens.getRefreshToken()), scheme);
        return List.of(optimizeAuthCookie, optimizeRefreshCookie);
    }

    public List<Cookie> createOptimizeDeleteAuthCookies() {
        return List.of(this.authCookieService.createDeleteOptimizeAuthCookie(), this.authCookieService.createDeleteOptimizeRefreshCookie());
    }

    public List<Cookie> createOptimizeDeleteAuthNewCookies() {
        return List.of(this.authCookieService.createDeleteOptimizeAuthNewCookie(true), this.authCookieService.createDeleteOptimizeRefreshNewCookie(true));
    }

    public URI buildAuthorizeUri(String redirectUri) {
        String authorizeUri = CCSMTokenService.appendCallbackSubpath(this.getConfiguredRedirectUri().orElse(redirectUri));
        LOG.trace("Authorizing with authorizeUri: {}", (Object)authorizeUri);
        return this.authentication().authorizeUriBuilder(authorizeUri).build();
    }

    public Tokens exchangeAuthCode(AuthCodeDto authCode, URI uri) {
        String redirectUri = this.getConfiguredRedirectUri().map(CCSMTokenService::appendCallbackSubpath).orElse(uri.toString());
        LOG.trace("Exchanging auth code with redirectUri: {}", (Object)redirectUri);
        try {
            return this.authentication().exchangeAuthCode(authCode, redirectUri);
        }
        catch (CodeExchangeException | RestException e) {
            throw new NotAuthorizedException("Token exchange failed", e);
        }
    }

    private Date getRefreshTokenExpirationDate(String refreshToken) {
        try {
            DecodedJWT decodedRefreshToken = this.authentication().decodeJWT(refreshToken);
            Date refreshTokenExpiresAt = decodedRefreshToken.getExpiresAt();
            LOG.trace("Refresh token will expire at {}", (Object)refreshTokenExpiresAt);
            return refreshTokenExpiresAt;
        }
        catch (TokenDecodeException e) {
            LOG.trace("Refresh token is not a JWT and expiry date can not be determined. Error message: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static String appendCallbackSubpath(String configuredRedirectUri) {
        return configuredRedirectUri + "/api/authentication/callback";
    }

    private Optional<String> getConfiguredRedirectUri() {
        String configuredRedirectRootUrl = this.configurationService.getAuthConfiguration().getCcsmAuthConfiguration().getRedirectRootUrl();
        return StringUtils.isEmpty((CharSequence)configuredRedirectRootUrl) ? Optional.empty() : Optional.of(configuredRedirectRootUrl);
    }

    public AccessToken verifyToken(String accessToken) {
        try {
            AccessToken verifiedToken = this.authentication().verifyToken(this.extractTokenFromAuthorizationValue(accessToken));
            if (!CCSMTokenService.userHasOptimizeAuthorization(verifiedToken)) {
                throw new NotAuthorizedException("User is not authorized to access Optimize");
            }
            return verifiedToken;
        }
        catch (TokenVerificationException ex) {
            throw new NotAuthorizedException("Token could not be verified", (Throwable)ex);
        }
    }

    public Tokens renewToken(String refreshToken) {
        try {
            return this.authentication().renewToken(this.extractTokenFromAuthorizationValue(refreshToken));
        }
        catch (IdentityException ex) {
            throw new NotAuthorizedException("Token could not be renewed", (Throwable)ex);
        }
    }

    public void revokeToken(String refreshToken) {
        try {
            this.authentication().revokeToken(this.extractTokenFromAuthorizationValue(refreshToken));
        }
        catch (IdentityException ex) {
            throw new NotAuthorizedException("Token could not be revoked", (Throwable)ex);
        }
    }

    public String getSubjectFromToken(String accessToken) {
        try {
            return this.authentication().decodeJWT(this.extractTokenFromAuthorizationValue(accessToken)).getSubject();
        }
        catch (TokenDecodeException ex) {
            throw new NotAuthorizedException("Token could not be decoded", (Throwable)ex);
        }
    }

    public UserDto getUserInfoFromToken(String userId, String accessToken) {
        UserDetails userDetails = this.verifyToken(this.extractTokenFromAuthorizationValue(accessToken)).getUserDetails();
        return new UserDto(userId, userDetails.getName().orElseGet(() -> userDetails.getUsername().orElse(userId)), userDetails.getEmail().orElse(userId), Collections.emptyList());
    }

    public Optional<String> getCurrentUserIdFromAuthToken() {
        try {
            return this.getCurrentUserAuthToken().map(token -> this.authentication().decodeJWT(token).getSubject());
        }
        catch (TokenDecodeException ex) {
            throw new NotAuthorizedException("Token could not be decoded", (Throwable)ex);
        }
    }

    public Optional<String> getCurrentUserAuthToken() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).filter(ServletRequestAttributes.class::isInstance).map(ServletRequestAttributes.class::cast).map(ServletRequestAttributes::getRequest).flatMap(AuthCookieService::getAuthCookieToken);
    }

    public List<TenantDto> getAuthorizedTenantsFromToken(String accessToken) {
        try {
            return this.identity.tenants().forToken(accessToken).stream().map(tenant -> new TenantDto(tenant.getTenantId(), tenant.getName(), "zeebe")).toList();
        }
        catch (Exception e) {
            LOG.error("Could not retrieve authorized tenants from identity.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private String extractTokenFromAuthorizationValue(String cookieValue) {
        if (cookieValue.startsWith("Bearer ")) {
            return cookieValue.substring("Bearer ".length()).trim();
        }
        return cookieValue;
    }

    private Authentication authentication() {
        return this.identity.authentication();
    }

    private static boolean userHasOptimizeAuthorization(AccessToken accessToken) {
        return accessToken.getPermissions().contains(OPTIMIZE_PERMISSION);
    }
}

