/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.security;

import io.camunda.optimize.dto.optimize.IdentityDto;
import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.RoleType;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDataDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionRoleRequestDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizedCollectionDefinitionDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.reader.CollectionReader;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AuthorizedCollectionService {
    private static final String VIEW_NOT_AUTHORIZED_MESSAGE = "User [%s] is not authorized to access collection [%s].";
    private static final String EDIT_NOT_AUTHORIZED_MESSAGE = "User [%s] is not authorized to edit/delete collection [%s].";
    private static final String RESOURCE_EDIT_NOT_AUTHORIZED_MESSAGE = "User [%s] does not have the role to add/edit collection [%s] resources.";
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizedCollectionService.class);
    private final CollectionReader collectionReader;
    private final AbstractIdentityService identityService;

    public AuthorizedCollectionService(CollectionReader collectionReader, AbstractIdentityService identityService) {
        this.collectionReader = collectionReader;
        this.identityService = identityService;
    }

    public Optional<RoleType> getUsersCollectionResourceRole(String userId, String collectionId) throws NotFoundException, ForbiddenException {
        return this.getAuthorizedCollectionDefinition(userId, collectionId).map(AuthorizedCollectionDefinitionDto::getCollectionResourceRole);
    }

    public AuthorizedCollectionDefinitionDto getAuthorizedCollectionDefinitionOrFail(String userId, String collectionId) {
        return this.getAuthorizedCollectionDefinition(userId, collectionId).orElseThrow(() -> new ForbiddenException(String.format(VIEW_NOT_AUTHORIZED_MESSAGE, userId, collectionId)));
    }

    public AuthorizedCollectionDefinitionDto getAuthorizedCollectionAndVerifyUserAuthorizedToManageOrFail(String userId, String collectionId) {
        AuthorizedCollectionDefinitionDto collectionDefinition = this.getAuthorizedCollectionDefinitionOrFail(userId, collectionId);
        if (collectionDefinition.getCurrentUserRole().ordinal() < RoleType.MANAGER.ordinal()) {
            throw new ForbiddenException(String.format(EDIT_NOT_AUTHORIZED_MESSAGE, userId, collectionId));
        }
        return collectionDefinition;
    }

    public void verifyUserAuthorizedToEditCollectionResources(String userId, String collectionId) throws NotFoundException, ForbiddenException {
        AuthorizedCollectionDefinitionDto authorizedCollection;
        if (collectionId != null && (authorizedCollection = this.getAuthorizedCollectionDefinitionOrFail(userId, collectionId)).getCurrentUserRole().ordinal() < RoleType.EDITOR.ordinal()) {
            throw new ForbiddenException(String.format(RESOURCE_EDIT_NOT_AUTHORIZED_MESSAGE, userId, collectionId));
        }
    }

    public void verifyUserAuthorizedToEditCollectionRole(String userId, String collectionId, String roleId) throws NotFoundException, ForbiddenException {
        AuthorizedCollectionDefinitionDto authCollectionDto = this.getAuthorizedCollectionAndVerifyUserAuthorizedToManageOrFail(userId, collectionId);
        ((CollectionDataDto)authCollectionDto.getDefinitionDto().getData()).getRoles().stream().filter(role -> role.getId().equals(roleId)).forEach(role -> this.identityService.validateUserAuthorizedToAccessRoleOrFail(userId, role.getIdentity()));
    }

    public List<AuthorizedCollectionDefinitionDto> getAuthorizedCollectionDefinitions(String userId) {
        return this.collectionReader.getAllCollections().stream().map(definitionDto -> this.resolveToAuthorizedCollection(userId, (CollectionDefinitionDto)definitionDto)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<AuthorizedCollectionDefinitionDto> getAuthorizedCollectionDefinition(String userId, String collectionId) {
        Optional<CollectionDefinitionDto> collectionDefinition = this.collectionReader.getCollection(collectionId);
        if (collectionDefinition.isEmpty()) {
            LOG.error("Was not able to retrieve collection with id [{}] from the database.", (Object)collectionId);
            throw new NotFoundException("Collection does not exist! Tried to retrieve collection with id " + collectionId);
        }
        return this.resolveToAuthorizedCollection(userId, collectionDefinition.get());
    }

    private Optional<AuthorizedCollectionDefinitionDto> resolveToAuthorizedCollection(String userId, CollectionDefinitionDto collectionDefinition) {
        List collectionRoles = ((CollectionDataDto)collectionDefinition.getData()).getRoles();
        Set userGroupIds = this.identityService.getAllGroupsOfUser(userId).stream().map(IdentityDto::getId).collect(Collectors.toSet());
        Optional<CollectionRoleRequestDto> highestGrantedAuthorization = collectionRoles.stream().filter(roleDto -> roleDto.getIdentity().getType().equals((Object)IdentityType.USER)).filter(roleDto -> userId.equals(roleDto.getIdentity().getId())).reduce(BinaryOperator.maxBy(Comparator.comparing(CollectionRoleRequestDto::getRole)));
        if (highestGrantedAuthorization.isEmpty()) {
            highestGrantedAuthorization = collectionRoles.stream().filter(roleDto -> roleDto.getIdentity().getType().equals((Object)IdentityType.GROUP)).filter(roleDto -> userGroupIds.contains(roleDto.getIdentity().getId())).reduce(BinaryOperator.maxBy(Comparator.comparing(CollectionRoleRequestDto::getRole)));
        }
        Optional<RoleType> userRole = highestGrantedAuthorization.map(CollectionRoleRequestDto::getRole);
        return userRole.map(roleType -> new AuthorizedCollectionDefinitionDto(roleType, collectionDefinition));
    }
}

