/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.onboarding;

import io.camunda.optimize.service.AbstractScheduledService;
import io.camunda.optimize.service.ProcessOverviewService;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.reader.ProcessInstanceReader;
import io.camunda.optimize.service.db.writer.ProcessDefinitionWriter;
import io.camunda.optimize.service.importing.CustomerOnboardingDataImportService;
import io.camunda.optimize.service.onboarding.CCSaaSOnboardingPanelNotificationService;
import io.camunda.optimize.service.onboarding.OnboardingEmailNotificationService;
import io.camunda.optimize.service.util.configuration.ConfigurationReloadable;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.util.HashSet;
import java.util.function.Consumer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.stereotype.Component;

@Component
public class OnboardingSchedulerService
extends AbstractScheduledService
implements ConfigurationReloadable {
    private static final Logger LOG = LoggerFactory.getLogger(OnboardingSchedulerService.class);
    private final ProcessDefinitionReader processDefinitionReader;
    private final ProcessDefinitionWriter processDefinitionWriter;
    private final ProcessInstanceReader processInstanceReader;
    private final ConfigurationService configurationService;
    private final OnboardingEmailNotificationService onboardingEmailNotificationService;
    private final ProcessOverviewService processOverviewService;
    private final CustomerOnboardingDataImportService onboardingDataService;
    private CCSaaSOnboardingPanelNotificationService saaSPanelNotificationService;
    @Autowired
    private ApplicationContext applicationContext;
    private int intervalToCheckForOnboardingDataInSeconds;
    private Consumer<String> emailNotificationHandler;
    private Consumer<String> panelNotificationHandler;

    public OnboardingSchedulerService(ProcessDefinitionReader processDefinitionReader, ProcessDefinitionWriter processDefinitionWriter, ProcessInstanceReader processInstanceReader, ConfigurationService configurationService, OnboardingEmailNotificationService onboardingEmailNotificationService, ProcessOverviewService processOverviewService, CustomerOnboardingDataImportService onboardingDataService) {
        this.processDefinitionReader = processDefinitionReader;
        this.processDefinitionWriter = processDefinitionWriter;
        this.processInstanceReader = processInstanceReader;
        this.configurationService = configurationService;
        this.onboardingEmailNotificationService = onboardingEmailNotificationService;
        this.processOverviewService = processOverviewService;
        this.onboardingDataService = onboardingDataService;
    }

    @PostConstruct
    public void init() {
        this.emailNotificationHandler = processDefKey -> {};
        this.panelNotificationHandler = processDefKey -> {};
        this.setUpScheduler();
    }

    public void setUpScheduler() {
        if (this.configurationService.getOnboarding().isScheduleProcessOnboardingChecks()) {
            LOG.info("Initializing OnboardingScheduler");
            this.setIntervalToCheckForOnboardingDataInSeconds(Math.max(60, this.configurationService.getOnboarding().getIntervalForCheckingTriggerForOnboardingEmails()));
            this.setupOnboardingEmailNotifications();
            this.setupOnboardingPanelNotifications();
            this.startOnboardingScheduling();
        } else {
            LOG.info("Will not schedule checks for process onboarding state as this is disabled by configuration");
        }
    }

    public void setupOnboardingEmailNotifications() {
        if (this.configurationService.getOnboarding().isEnableOnboardingEmails()) {
            this.setEmailNotificationHandler(this.onboardingEmailNotificationService::sendOnboardingEmailWithErrorHandling);
        } else {
            LOG.info("Onboarding emails deactivated by configuration");
        }
    }

    public void setupOnboardingPanelNotifications() {
        if (this.applicationContext.containsBeanDefinition(CCSaaSOnboardingPanelNotificationService.class.getSimpleName())) {
            if (this.configurationService.getPanelNotificationConfiguration().isEnabled()) {
                this.setPanelNotificationHandler(processDefKey -> ((CCSaaSOnboardingPanelNotificationService)this.applicationContext.getBean(CCSaaSOnboardingPanelNotificationService.class)).sendOnboardingPanelNotification((String)processDefKey));
            } else {
                LOG.info("Onboarding panel notifications deactivated by configuration");
            }
        }
    }

    public void onboardNewProcesses() {
        HashSet<String> processesNewlyOnboarded = new HashSet<String>();
        for (String processToBeOnboarded : this.processDefinitionReader.getAllNonOnboardedProcessDefinitionKeys()) {
            this.resolveAnyPendingOwnerAuthorizations(processToBeOnboarded);
            if (!this.processHasStartedInstance(processToBeOnboarded)) continue;
            this.emailNotificationHandler.accept(processToBeOnboarded);
            this.panelNotificationHandler.accept(processToBeOnboarded);
            processesNewlyOnboarded.add(processToBeOnboarded);
        }
        if (!processesNewlyOnboarded.isEmpty()) {
            this.processDefinitionWriter.markDefinitionKeysAsOnboarded(processesNewlyOnboarded);
        }
    }

    public void reloadConfiguration(ApplicationContext context) {
        this.init();
    }

    public synchronized void startOnboardingScheduling() {
        LOG.info("Starting onboarding scheduling");
        this.startScheduling();
    }

    @PreDestroy
    public synchronized void stopOnboardingScheduling() {
        LOG.info("Stopping onboarding scheduling");
        this.stopScheduling();
    }

    @Override
    protected void run() {
        LOG.info("Checking whether new data would trigger onboarding");
        this.onboardNewProcesses();
        LOG.info("Onboarding check completed");
    }

    @Override
    protected Trigger createScheduleTrigger() {
        return new PeriodicTrigger(Duration.ofSeconds(this.getIntervalToCheckForOnboardingDataInSeconds()));
    }

    private boolean processHasStartedInstance(String processToBeEvaluated) {
        return this.processInstanceReader.processDefinitionHasStartedInstances(processToBeEvaluated);
    }

    private void resolveAnyPendingOwnerAuthorizations(String processToBeOnboarded) {
        this.processOverviewService.confirmOrDenyOwnershipData(processToBeOnboarded);
    }

    public ProcessDefinitionReader getProcessDefinitionReader() {
        return this.processDefinitionReader;
    }

    public ProcessDefinitionWriter getProcessDefinitionWriter() {
        return this.processDefinitionWriter;
    }

    public ProcessInstanceReader getProcessInstanceReader() {
        return this.processInstanceReader;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public OnboardingEmailNotificationService getOnboardingEmailNotificationService() {
        return this.onboardingEmailNotificationService;
    }

    public ProcessOverviewService getProcessOverviewService() {
        return this.processOverviewService;
    }

    public CustomerOnboardingDataImportService getOnboardingDataService() {
        return this.onboardingDataService;
    }

    public CCSaaSOnboardingPanelNotificationService getSaaSPanelNotificationService() {
        return this.saaSPanelNotificationService;
    }

    public void setSaaSPanelNotificationService(CCSaaSOnboardingPanelNotificationService saaSPanelNotificationService) {
        this.saaSPanelNotificationService = saaSPanelNotificationService;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public int getIntervalToCheckForOnboardingDataInSeconds() {
        return this.intervalToCheckForOnboardingDataInSeconds;
    }

    public void setIntervalToCheckForOnboardingDataInSeconds(int intervalToCheckForOnboardingDataInSeconds) {
        this.intervalToCheckForOnboardingDataInSeconds = intervalToCheckForOnboardingDataInSeconds;
    }

    public Consumer<String> getEmailNotificationHandler() {
        return this.emailNotificationHandler;
    }

    public void setEmailNotificationHandler(Consumer<String> emailNotificationHandler) {
        this.emailNotificationHandler = emailNotificationHandler;
    }

    public Consumer<String> getPanelNotificationHandler() {
        return this.panelNotificationHandler;
    }

    public void setPanelNotificationHandler(Consumer<String> panelNotificationHandler) {
        this.panelNotificationHandler = panelNotificationHandler;
    }

    protected boolean canEqual(Object other) {
        return other instanceof OnboardingSchedulerService;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return "OnboardingSchedulerService(processDefinitionReader=" + String.valueOf(this.getProcessDefinitionReader()) + ", processDefinitionWriter=" + String.valueOf(this.getProcessDefinitionWriter()) + ", processInstanceReader=" + String.valueOf(this.getProcessInstanceReader()) + ", configurationService=" + String.valueOf(this.getConfigurationService()) + ", onboardingEmailNotificationService=" + String.valueOf(this.getOnboardingEmailNotificationService()) + ", processOverviewService=" + String.valueOf(this.getProcessOverviewService()) + ", onboardingDataService=" + String.valueOf(this.getOnboardingDataService()) + ", saaSPanelNotificationService=" + String.valueOf(this.getSaaSPanelNotificationService()) + ", applicationContext=" + String.valueOf(this.getApplicationContext()) + ", intervalToCheckForOnboardingDataInSeconds=" + this.getIntervalToCheckForOnboardingDataInSeconds() + ", emailNotificationHandler=" + String.valueOf(this.getEmailNotificationHandler()) + ", panelNotificationHandler=" + String.valueOf(this.getPanelNotificationHandler()) + ")";
    }
}

